/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.png.chunks;

import com.apple.jingle.leghorn.image.png.Chunk;
import com.apple.jingle.leghorn.image.png.PNGHeader;
import com.apple.jingle.leghorn.image.png.PNGParser;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;

public class BkgdChunk
extends Chunk {
    int colorType;
    int colorPaletteIndex;
    int backgroundIntensity;
    int[] rgbComponents;

    @Override
    public void parse(PNGHeader header, List<ValidationIssue> issues) throws IOException {
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(this.data, (long)this.data.length);
        this.colorType = header.getColorType();
        if (this.colorType == 3) {
            if (this.size != 1) {
                issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The size of this chunk is " + this.size + " it should be 1."));
            } else {
                this.colorPaletteIndex = basdi.readByte();
            }
        } else if (this.colorType == 0 || this.colorType == 4) {
            if (this.size != 2) {
                issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The size of this chunk is " + this.size + " it should be 2."));
            } else {
                this.backgroundIntensity = PNGParser.readU16((DataInput)basdi);
            }
        } else if (this.colorType == 2 || this.colorType == 6) {
            if (this.size != 12) {
                issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The size of this chunk is " + this.size + " it should be 12."));
            } else {
                this.rgbComponents = new int[3];
                for (int i = 0; i < 3; ++i) {
                    this.rgbComponents[i] = PNGParser.readU16((DataInput)basdi);
                }
            }
        }
    }

    @Override
    public List<ValidationIssue> validate(List<ValidationIssue> issues, PNGHeader header) {
        issues = super.validate(issues, header);
        return issues;
    }

    @Override
    public String toString() {
        String value = super.toString();
        if (this.colorType == 3) {
            value = value + "Color Palette Index: " + this.colorPaletteIndex;
        } else if (this.colorType == 0 || this.colorType == 4) {
            value = value + "Background Intensity: " + this.backgroundIntensity;
        } else if (this.colorType == 2 || this.colorType == 6) {
            value = value + "RGB Components: [" + this.rgbComponents[0] + ", " + this.rgbComponents[1] + ", " + this.rgbComponents[2] + "]";
        }
        return value;
    }
}

