/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.png;

import com.apple.jingle.leghorn.image.ImageDescription;
import com.apple.jingle.leghorn.image.png.Chunk;
import com.apple.jingle.leghorn.image.png.ColorType;
import com.apple.jingle.leghorn.image.png.PNGHeader;
import com.apple.jingle.leghorn.image.png.ParserState;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.leghorn.image.png.chunks.BkgdChunk;
import com.apple.jingle.leghorn.image.png.chunks.ChrmChunk;
import com.apple.jingle.leghorn.image.png.chunks.GamaChunk;
import com.apple.jingle.leghorn.image.png.chunks.IhdrChunk;
import com.apple.jingle.leghorn.image.png.chunks.PhysChunk;
import com.apple.jingle.leghorn.image.png.chunks.PlteChunk;
import com.apple.jingle.leghorn.image.png.chunks.TextChunk;
import com.apple.jingle.leghorn.image.png.chunks.TimeChunk;
import com.apple.jingle.leghorn.image.png.chunks.TrnsChunk;
import com.apple.jingle.leghorn.image.png.chunks.ZtxtChunk;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PNGParser {
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    public static final int MAX_PNG_4_BYTE_INT_SIZE = Integer.MAX_VALUE;
    private boolean shouldReadChunkData = false;
    private boolean shouldRunCRC = false;
    private PNGHeader header = null;
    private long position = 0L;
    private State state = State.UNINITIALIZED;
    private List<Chunk> chunks = new ArrayList<Chunk>();
    private boolean isProbablyGood = true;
    private boolean canDescribe = false;
    private boolean isDone = false;
    private byte[] buffer;
    private ParserState parserState;
    private long providedFileSize = -1L;
    private List<ValidationIssue> issues = new ArrayList<ValidationIssue>();
    protected static final Map<String, Class<? extends Chunk>> TYPE_CLASS_MAP = new HashMap<String, Class<? extends Chunk>>();
    private List<String> chunkArrangement = new ArrayList<String>();
    private ImageDescription imageDescription;

    PNGParser() {
    }

    public PNGParser(boolean calculateCRC) {
        this.shouldReadChunkData = calculateCRC;
        this.shouldRunCRC = calculateCRC;
    }

    public String toString() {
        return this.chunks.toString();
    }

    public ParserState initialize() {
        if (this.state != State.UNINITIALIZED) {
            throw new UnsupportedOperationException("Parser is already initialized. It cannot be initialized again.");
        }
        this.state = State.SIGNATURE;
        this.isProbablyGood = true;
        this.canDescribe = false;
        this.isDone = false;
        this.parserState = new ParserState(0, 8, this.isProbablyGood, this.isDone, this.canDescribe);
        return this.parserState;
    }

    public ParserState initialize(long fileSize) {
        this.providedFileSize = fileSize;
        return this.initialize();
    }

    public ParserState didRead(byte[] b, int offset, int len) throws IOException {
        this.parserState.addBytesRead(len);
        this.position += (long)len;
        if (this.providedFileSize > -1L && this.position > this.providedFileSize) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "We have read past the file size provided. Something is wrong.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (this.parserState.getBytesRead() == this.parserState.getNumBytesToRead()) {
            byte[] finalBuffer = new byte[len];
            System.arraycopy(b, offset, finalBuffer, 0, len);
            if (this.buffer != null) {
                System.arraycopy(b, offset, this.buffer, this.parserState.getBytesRead() - len, len);
                finalBuffer = this.buffer;
                this.buffer = null;
            }
            this.parserState.setBytesRead(0);
            if (this.state == State.SIGNATURE) {
                return this.parseSignature(finalBuffer);
            }
            if (this.state == State.CHUNK_HEADER) {
                return this.parseChunkHeader(finalBuffer);
            }
            if (this.state == State.CHUNK_DATA) {
                return this.parseChunkData(finalBuffer);
            }
            if (this.state == State.CHUNK_CRC) {
                return this.parseChunkCRC(finalBuffer);
            }
        } else {
            if (this.state == State.CHUNK_DATA && (this.getCurrentChunk().type.equals("IDAT") || !TYPE_CLASS_MAP.containsKey(this.getCurrentChunk().type))) {
                this.getCurrentChunk().computedCrc.update(b, offset, len);
                return this.parserState;
            }
            if (this.buffer == null) {
                this.buffer = new byte[this.parserState.getNumBytesToRead()];
            }
            System.arraycopy(b, offset, this.buffer, this.parserState.getBytesRead() - len, len);
            return this.parserState;
        }
        this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "Entered an impossible state while parsing.", MediaValidationCode.IMG_UNKNOWN_ERROR));
        throw new IllegalStateException("You have entered an impossible state. Well done.");
    }

    private ParserState parseSignature(byte[] b) throws UnsupportedEncodingException {
        this.state = State.CHUNK_HEADER;
        if (Arrays.equals(PNG_SIGNATURE, b)) {
            return this.parserState.set(0, 8, this.isProbablyGood, this.isDone, this.canDescribe);
        }
        this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "This files signature, doesn't match the PNG Signature.", MediaValidationCode.IMG_CONTAINER_INCOMPATIBLE));
        this.isProbablyGood = false;
        return this.parserState.set(0, 8, false, this.isDone, this.canDescribe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParserState parseChunkHeader(byte[] b) {
        this.state = State.CHUNK_DATA;
        int size = 0;
        String type = null;
        byte[] typeBytes = null;
        try (ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(b, (long)b.length);){
            size = basdi.readInt();
            this.validateChunkHeaderSize(size);
            typeBytes = new byte[4];
            basdi.readFully(typeBytes);
            type = new String(typeBytes, "ASCII");
        }
        catch (IOException ioe) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Trouble parsing header at chunk " + this.chunks.size(), MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        this.chunkArrangement.add(type);
        Chunk currentChunk = null;
        if (TYPE_CLASS_MAP.containsKey(type)) {
            try {
                currentChunk = TYPE_CLASS_MAP.get(type).newInstance();
            }
            catch (Exception e) {}
        } else {
            currentChunk = new Chunk();
        }
        currentChunk.setType(type);
        currentChunk.setSize(size);
        if (this.shouldRunCRC) {
            currentChunk.updateCrc(typeBytes);
        }
        this.chunks.add(currentChunk);
        if (currentChunk.getType().equals("IHDR")) {
            if (this.chunks.size() > 1) {
                this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "IHDR chunk is chunk  " + this.chunks.size() + ", not chunk 1.", MediaValidationCode.IMG_CONTAINER_INCOMPATIBLE));
                this.isProbablyGood = false;
            } else if (currentChunk.size != 13) {
                this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "IHDR chunk has size " + currentChunk.size + " and not 13.", MediaValidationCode.IMG_APPEARS_CORRUPT));
                this.isProbablyGood = false;
            }
            return this.parserState.set(0, currentChunk.size, this.isProbablyGood, this.isDone, this.canDescribe);
        }
        if (currentChunk.getType().equals("IDAT") && !this.canDescribe()) {
            this.imageDescription.setColorSpace(this.getColorSpace());
            byte colorTypeNumber = this.header.getColorType();
            ColorType colorType = ColorType.forTypeNumber(colorTypeNumber);
            if (colorType == null) {
                this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "Colortype " + colorTypeNumber + " does not match a valid colortype.", MediaValidationCode.IMG_APPEARS_CORRUPT));
                this.isProbablyGood = false;
                this.canDescribe = false;
            } else {
                this.imageDescription.setAlphaChannel(colorType.usesAlphaChannel());
                this.imageDescription.setColorMap(colorType.usesColorMap());
                this.canDescribe = true;
            }
        }
        if (this.shouldReadChunkData) {
            return this.parserState.set(0, currentChunk.size, this.isProbablyGood, this.isDone, this.canDescribe);
        }
        return this.parserState.set(currentChunk.size, 0, this.isProbablyGood, this.isDone, this.canDescribe);
    }

    private ParserState parseChunkData(byte[] b) throws IOException {
        this.state = State.CHUNK_CRC;
        Chunk currentChunk = this.getCurrentChunk();
        if (!currentChunk.type.equals("IDAT")) {
            currentChunk.data = b;
        }
        if (this.shouldRunCRC) {
            currentChunk.computedCrc.update(b);
        }
        try {
            currentChunk.parse(this.header, this.issues);
        }
        catch (IOException e) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Had trouble parsing chunk: " + currentChunk.getType(), MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (currentChunk instanceof IhdrChunk) {
            this.header = new PNGHeader();
            this.header.setWidth(((IhdrChunk)currentChunk).getWidth());
            this.header.setHeight(((IhdrChunk)currentChunk).getHeight());
            this.header.setBitDepth(((IhdrChunk)currentChunk).getBitDepth());
            this.header.setColorType(((IhdrChunk)currentChunk).getColorType());
            this.header.setCompressionMethod(((IhdrChunk)currentChunk).getCompressionMethod());
            this.header.setFilterMethod(((IhdrChunk)currentChunk).getFilterMethod());
            this.header.setInterlaceMethod(((IhdrChunk)currentChunk).getInterlaceMethod());
            this.imageDescription = new ImageDescription(this.header.getHeight(), this.header.getWidth(), this.header.getBitDepth());
        }
        this.issues = currentChunk.validate(this.issues, this.header);
        return this.parserState.set(0, 4, this.isProbablyGood, this.isDone, this.canDescribe);
    }

    private ParserState parseChunkCRC(byte[] b) throws IOException {
        this.state = State.CHUNK_HEADER;
        Chunk currentChunk = this.getCurrentChunk();
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(b, (long)b.length);
        currentChunk.crc = PNGParser.readU32((DataInput)basdi);
        if (this.shouldRunCRC && currentChunk.crc != currentChunk.computedCrc.getValue()) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Computed CRC (" + currentChunk.computedCrc.getValue() + ") does not match provided CRC (" + currentChunk.crc + ") in chunk " + this.chunks.size(), MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (currentChunk.type.equals("IEND")) {
            this.validateChunkArrangement();
            this.state = State.DONE;
            this.isDone = true;
            return this.parserState.set(0, 0, this.isProbablyGood, this.isDone, this.canDescribe);
        }
        return this.parserState.set(0, 8, this.isProbablyGood, this.isDone, this.canDescribe);
    }

    private Chunk getCurrentChunk() {
        return this.chunks.get(this.chunks.size() - 1);
    }

    private void validateChunkHeaderSize(int size) throws IOException {
        if (size < 0 || size > Integer.MAX_VALUE) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "The size of chunk " + this.chunks.size() + " is " + size + ". This is invalid.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
    }

    public static int readU16(DataInput input) throws IOException {
        byte[] bytesFor16 = new byte[2];
        input.readFully(bytesFor16);
        BigInteger u16BI = new BigInteger(1, bytesFor16);
        return u16BI.intValue();
    }

    public static long readU32(DataInput input) throws IOException {
        byte[] bytesFor32 = new byte[4];
        input.readFully(bytesFor32);
        BigInteger u32BI = new BigInteger(1, bytesFor32);
        return u32BI.longValue();
    }

    public void always(int a, int b) {
        if (a != b) {
            throw new IllegalArgumentException("a(" + a + ") != b(" + b + ")");
        }
    }

    public void validateChunkArrangement() throws IOException {
        if (this.header.getColorType() == 3 && this.containsNoChunksOfType("PLTE")) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "A PLTE was requried, but was not found.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        List<String> mustHaveOneChunk = Arrays.asList("IHDR");
        for (String chunkType : mustHaveOneChunk) {
            if (!this.containsMoreThanOneChunk(chunkType) && !this.containsNoChunksOfType(chunkType)) continue;
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Found more than one " + chunkType + " chunk. Expecting only one.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        List<String> mustHaveOnePLTEChunk = Arrays.asList("PLTE");
        for (String chunkType : mustHaveOnePLTEChunk) {
            if (!this.containsMoreThanOneChunk(chunkType)) continue;
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Found more than one " + chunkType + " chunk. There must be no more than one.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        List<String> expectingOneChunk = Arrays.asList("IEND", "cHRM", "gAMA", "iCCP", "sBIT", "sRGB", "bKGD", "hIST", "tRNS", "pHYs", "tIME");
        for (String chunkType : expectingOneChunk) {
            if (!this.containsMoreThanOneChunk(chunkType)) continue;
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "Found more than one " + chunkType + " chunk. Expecting only one.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        List<String> chunksAfterIdat = Arrays.asList("bKGD", "hIST", "tRNS", "cHRM", "gAMA", "iCCP", "sBIT", "sRGB", "pHYs", "sPLT", "oFFs");
        for (String chunkType : chunksAfterIdat) {
            if (this.firstChunkAppearsBeforeSecondChunk(chunkType, "IDAT")) continue;
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "Found " + chunkType + " after an IDAT chunk.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (!this.firstChunkAppearsBeforeSecondChunk("PLTE", "IDAT")) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Found PLTE chunk after an IDAT chunk.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        List<String> chunksBeforePlteAndIdat = Arrays.asList("cHRM", "gAMA", "iCCP", "sBIT", "sRGB");
        for (String chunkType : chunksBeforePlteAndIdat) {
            if (this.firstChunkAppearsBeforeSecondChunk(chunkType, "PLTE")) continue;
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "Found " + chunkType + " after a PLTE chunk.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        List<String> chunksAfterPlte = Arrays.asList("bKGD", "hIST", "tRNS");
        for (String chunkType : chunksAfterPlte) {
            if (this.firstChunkAppearsBeforeSecondChunk(chunkType, "PLTE")) continue;
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "Found " + chunkType + " before a PLTE chunk.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (this.chunkArrangement.contains("PLTE") && this.header.getBitDepth() == 16) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Found a bit depth of 16 in the IHDR chunk while a PLTE chunk exists. This is invalid.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (!this.chunkArrangement.contains("IDAT")) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "This image doesn't contain an IDAT chunk.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        boolean seenIDAT = false;
        boolean seenOther = false;
        for (String chunk : this.chunkArrangement) {
            if (chunk.equals("IDAT")) {
                seenIDAT = true;
            }
            if (seenIDAT && !chunk.equals("IDAT")) {
                seenOther = true;
            }
            if (!seenOther || !chunk.equals("IDAT")) continue;
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Nonconsecutive IDAT chunks.", MediaValidationCode.IMG_APPEARS_CORRUPT));
            break;
        }
    }

    private boolean containsNoChunksOfType(String chunkType) {
        return !this.chunkArrangement.contains(chunkType);
    }

    public boolean containsMoreThanOneChunk(String type) {
        return this.chunkArrangement.indexOf(type) != this.chunkArrangement.lastIndexOf(type);
    }

    public boolean firstChunkAppearsBeforeSecondChunk(String firstChunk, String secondChunk) {
        int firstChunkIndex = this.chunkArrangement.lastIndexOf(firstChunk);
        int secondChunkIndex = this.chunkArrangement.lastIndexOf(secondChunk);
        if (firstChunkIndex == -1 || secondChunkIndex == -1) {
            return true;
        }
        return firstChunkIndex < secondChunkIndex;
    }

    public List<ValidationIssue> getValidationIssues() {
        return this.issues;
    }

    public ImageDescription getDescription() {
        return this.imageDescription;
    }

    public boolean canDescribe() {
        return this.parserState.isCanDescribe();
    }

    public String getColorSpace() {
        if (this.hasICCProfile()) {
            if (this.header.getColorType() == 0 || this.header.getColorType() == 4) {
                return "Greyscale";
            }
            return "RGB";
        }
        if (this.header.getColorType() == 6) {
            return ColorType.RGB.name();
        }
        if (this.header.getColorType() == 4) {
            return ColorType.Grayscale.name();
        }
        return ColorType.forTypeNumber(this.header.getColorType()).toString();
    }

    public boolean hasICCProfile() {
        for (Chunk chunk : this.chunks) {
            if (!chunk.getType().equals("iCCP")) continue;
            return true;
        }
        return false;
    }

    static {
        TYPE_CLASS_MAP.put("IHDR", IhdrChunk.class);
        TYPE_CLASS_MAP.put("PLTE", PlteChunk.class);
        TYPE_CLASS_MAP.put("bKGD", BkgdChunk.class);
        TYPE_CLASS_MAP.put("cHRM", ChrmChunk.class);
        TYPE_CLASS_MAP.put("gAMA", GamaChunk.class);
        TYPE_CLASS_MAP.put("pHYs", PhysChunk.class);
        TYPE_CLASS_MAP.put("tEXt", TextChunk.class);
        TYPE_CLASS_MAP.put("tIME", TimeChunk.class);
        TYPE_CLASS_MAP.put("zTXt", ZtxtChunk.class);
        TYPE_CLASS_MAP.put("tRNS", TrnsChunk.class);
    }

    public static enum State {
        UNINITIALIZED,
        SIGNATURE,
        CHUNK_HEADER,
        CHUNK_DATA,
        CHUNK_CRC,
        DONE;

    }
}

