/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.png;

import java.util.HashMap;

public enum ColorType {
    Grayscale(0),
    RGB(2),
    Indexed(3),
    GrayscaleWithAlpha(4),
    RGBWithAlpha(6);

    private int typeNumber;
    private static HashMap<Integer, ColorType> numberMap;

    private ColorType(int type) {
        this.typeNumber = type;
    }

    public int getColorTypeNumber() {
        return this.typeNumber;
    }

    public boolean usesAlphaChannel() {
        return this.getColorTypeNumber() == 4 || this.getColorTypeNumber() == 6;
    }

    public boolean usesColorMap() {
        return this.getColorTypeNumber() == 3;
    }

    public static ColorType forTypeNumber(int tn) {
        if (numberMap.containsKey(tn)) {
            return numberMap.get(tn);
        }
        return null;
    }

    static {
        ColorType[] codes = ColorType.values();
        numberMap = new HashMap(codes.length);
        for (int i = 0; i < codes.length; ++i) {
            ColorType code = codes[i];
            numberMap.put(code.getColorTypeNumber(), code);
        }
    }
}

