/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.png;

import com.apple.jingle.leghorn.image.png.PNGHeader;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class Chunk {
    protected int size;
    protected String type;
    protected byte[] data;
    protected long crc;
    protected CRC32 computedCrc = new CRC32();
    private static List<String> knownCriticalChunks = new ArrayList<String>();

    public void parse(PNGHeader header, List<ValidationIssue> issues) throws IOException {
    }

    public List<ValidationIssue> validate(List<ValidationIssue> issues, PNGHeader header) {
        if (!this.isValidType()) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Invalid chunk type: " + this.type, MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (this.isCritical() && !knownCriticalChunks.contains(this.type)) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Unknown critical chunk: " + this.type, MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        return issues;
    }

    public boolean isValidType() {
        Pattern p = Pattern.compile("[a-zA-Z]{2,2}[A-Z][a-zA-Z]");
        Matcher m = p.matcher(this.type);
        return m.find();
    }

    public boolean isCritical() {
        return Character.isUpperCase(this.type.getBytes()[0]);
    }

    public boolean isPublic() {
        return Character.isUpperCase(this.type.getBytes()[1]);
    }

    public boolean isReserved() {
        return Character.isUpperCase(this.type.getBytes()[2]);
    }

    public boolean isSafeToCopy() {
        return Character.isUpperCase(this.type.getBytes()[3]);
    }

    public boolean hasValidType() {
        return this.isReserved();
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void updateCrc(byte[] b) {
        this.computedCrc.update(b);
    }

    public int getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getCrc() {
        return this.crc;
    }

    public CRC32 getComputedCrc() {
        return this.computedCrc;
    }

    public String toString() {
        return "\n[" + this.type + "]\n" + "size: " + this.size + "\ncrc: " + this.crc + "\ncomputed crc: " + this.computedCrc.getValue() + "\n";
    }

    static {
        knownCriticalChunks.add("IHDR");
        knownCriticalChunks.add("IDAT");
        knownCriticalChunks.add("PLTE");
        knownCriticalChunks.add("IEND");
    }
}

