/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.jpeg.markers;

import com.apple.jingle.leghorn.image.jpeg.JPEGParser;
import com.apple.jingle.leghorn.image.jpeg.Marker;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StartOfFrameMarker
extends Marker {
    int samplePrecision;
    int imageHeight;
    int imageWidth;
    int numberOfComponents;
    List<Component> components;

    @Override
    public void parse(List<ValidationIssue> issues) throws IOException {
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(this.data, (long)this.data.length);
        this.samplePrecision = basdi.readUnsignedByte();
        this.imageHeight = JPEGParser.readU16((DataInput)basdi);
        this.imageWidth = JPEGParser.readU16((DataInput)basdi);
        this.numberOfComponents = basdi.readUnsignedByte();
        this.components = new ArrayList<Component>();
        for (int i = 0; i < this.numberOfComponents; ++i) {
            Component currentComponent = new Component();
            currentComponent.parse((DataInput)basdi);
            this.components.add(currentComponent);
        }
    }

    @Override
    public String toString() {
        return "StartOfFrameMarker{samplePrecision=" + this.samplePrecision + ", imageHeight=" + this.imageHeight + ", imageWidth=" + this.imageWidth + ", numberOfComponents=" + this.numberOfComponents + ", components=" + this.components + '}';
    }

    public int getSamplePrecision() {
        return this.samplePrecision;
    }

    public void setSamplePrecision(int samplePrecision) {
        this.samplePrecision = samplePrecision;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    public void setNumberOfComponents(int numberOfComponents) {
        this.numberOfComponents = numberOfComponents;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public class Component {
        int identifier;
        byte sampling;
        byte quantizationTableIdentifier;

        public int getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(int identifier) {
            this.identifier = identifier;
        }

        public byte getSampling() {
            return this.sampling;
        }

        public void setSampling(byte sampling) {
            this.sampling = sampling;
        }

        public byte getQuantizationTableIdentifier() {
            return this.quantizationTableIdentifier;
        }

        public void setQuantizationTableIdentifier(byte quantizationTableIdentifier) {
            this.quantizationTableIdentifier = quantizationTableIdentifier;
        }

        public String toString() {
            return "Component{identifier=" + this.identifier + ", sampling=" + this.sampling + ", quantizationTableIdentifier=" + this.quantizationTableIdentifier + '}';
        }

        public void parse(DataInput basdi) throws IOException {
            this.identifier = basdi.readByte();
            this.sampling = basdi.readByte();
            this.quantizationTableIdentifier = basdi.readByte();
        }
    }
}

