/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.jpeg.markers;

import com.apple.jingle.leghorn.image.jpeg.JPEGParser;
import com.apple.jingle.leghorn.image.jpeg.Marker;
import com.apple.jingle.leghorn.image.jpeg.markers.AsciiIfd;
import com.apple.jingle.leghorn.image.jpeg.markers.ByteIfd;
import com.apple.jingle.leghorn.image.jpeg.markers.Ifd;
import com.apple.jingle.leghorn.image.jpeg.markers.LongIfd;
import com.apple.jingle.leghorn.image.jpeg.markers.RationalIfd;
import com.apple.jingle.leghorn.image.jpeg.markers.ShortIfd;
import com.apple.jingle.leghorn.image.jpeg.markers.SlongIfd;
import com.apple.jingle.leghorn.image.jpeg.markers.SrationalIfd;
import com.apple.jingle.leghorn.image.jpeg.markers.UndefinedIfd;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class App1Marker
extends Marker {
    public static final Map<IfdType, Class<? extends Ifd>> IFD_TYPE_CLASS_MAP = new HashMap<IfdType, Class<? extends Ifd>>();
    int exif;
    List<Ifd> ifds = new ArrayList<Ifd>();
    int ifdCount;
    ByteAlign byteAlign;
    int firstIFDOffset;

    @Override
    public String toString() {
        return this.ifds.toString();
    }

    public void parse() throws IOException {
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(this.data, (long)this.data.length);
        JPEGParser.readFourCC((DataInput)basdi);
        basdi.skip(2L);
        int ba = basdi.readUnsignedShort();
        this.byteAlign = ba == 19789 ? ByteAlign.MOTOROLA : ByteAlign.INTEL;
        basdi.skip(2L);
        if (this.byteAlign == ByteAlign.MOTOROLA) {
            this.firstIFDOffset = basdi.readInt();
            this.ifdCount = JPEGParser.readU16((DataInput)basdi);
            basdi.seek((long)(this.firstIFDOffset + 8));
            for (int i = 0; i < this.ifdCount; ++i) {
                int tag = JPEGParser.readU16((DataInput)basdi);
                int type = JPEGParser.readU16((DataInput)basdi);
                long count = JPEGParser.readU32((DataInput)basdi);
                Ifd currentIfd = null;
                if (IFD_TYPE_CLASS_MAP.containsKey((Object)IfdType.get(type))) {
                    try {
                        currentIfd = IFD_TYPE_CLASS_MAP.get((Object)IfdType.get(type)).newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    currentIfd = new Ifd();
                }
                currentIfd.setTag(tag);
                currentIfd.setType(IfdType.get(type));
                currentIfd.setCount(count);
                switch (currentIfd.getType()) {
                    case ASCII: {
                        if (currentIfd.getCount() < 5L) {
                            byte[] b = new byte[(int)currentIfd.getCount() - 1];
                            basdi.readFully(b);
                            ((AsciiIfd)currentIfd).setValue(new String(b, "ASCII"));
                            basdi.skip(5L - currentIfd.getCount());
                            break;
                        }
                        currentIfd.setOffset(JPEGParser.readU32((DataInput)basdi));
                        break;
                    }
                    case BYTE: {
                        ((ByteIfd)currentIfd).setValue(basdi.readUnsignedByte());
                        basdi.skip(3L);
                        break;
                    }
                    case SHORT: {
                        ((ShortIfd)currentIfd).setValue(basdi.readShort());
                        basdi.skip(2L);
                        break;
                    }
                    case UNDEFINED: {
                        ((UndefinedIfd)currentIfd).setValue(basdi.readUnsignedByte());
                        basdi.skip(3L);
                        break;
                    }
                    default: {
                        currentIfd.setOffset(JPEGParser.readU32((DataInput)basdi));
                    }
                }
                this.ifds.add(currentIfd);
            }
        } else {
            this.firstIFDOffset = this.reverseByteOrder(basdi.readInt());
            this.ifdCount = this.reverseU16ByteOrder(JPEGParser.readU16((DataInput)basdi));
            basdi.seek((long)(this.firstIFDOffset + 8));
            for (int i = 0; i < this.ifdCount; ++i) {
                int tag = this.reverseU16ByteOrder(JPEGParser.readU16((DataInput)basdi));
                int type = this.reverseU16ByteOrder(JPEGParser.readU16((DataInput)basdi));
                long count = this.reverseByteOrder(JPEGParser.readU32((DataInput)basdi));
                Ifd currentIfd = null;
                if (IFD_TYPE_CLASS_MAP.containsKey((Object)IfdType.get(type))) {
                    try {
                        currentIfd = IFD_TYPE_CLASS_MAP.get((Object)IfdType.get(type)).newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    currentIfd = new Ifd();
                }
                currentIfd.setTag(tag);
                currentIfd.setType(IfdType.get(type));
                currentIfd.setCount(count);
                switch (currentIfd.getType()) {
                    case ASCII: {
                        if (currentIfd.getCount() < 5L) {
                            byte[] b = new byte[(int)currentIfd.getCount() - 1];
                            basdi.readFully(b);
                            ((AsciiIfd)currentIfd).setValue(new String(b, "ASCII"));
                            basdi.skip(5L - currentIfd.getCount());
                            break;
                        }
                        currentIfd.setOffset(JPEGParser.readU32((DataInput)basdi));
                        break;
                    }
                    case BYTE: {
                        ((ByteIfd)currentIfd).setValue(basdi.readUnsignedByte());
                        basdi.skip(3L);
                        break;
                    }
                    case SHORT: {
                        ((ShortIfd)currentIfd).setValue(basdi.readShort());
                        basdi.skip(2L);
                        break;
                    }
                    case UNDEFINED: {
                        ((UndefinedIfd)currentIfd).setValue(basdi.readUnsignedByte());
                        basdi.skip(3L);
                        break;
                    }
                    default: {
                        currentIfd.setOffset(JPEGParser.readU32((DataInput)basdi));
                    }
                }
                this.ifds.add(currentIfd);
            }
            for (Ifd ifd : this.ifds) {
                if (ifd.getCount() <= 4L) continue;
                basdi.seek(ifd.getOffset() + 6L);
                IfdType t = ifd.getType();
                switch (t) {
                    case ASCII: {
                        byte[] b = new byte[(int)ifd.getCount() - 1];
                        basdi.readFully(b);
                        ((AsciiIfd)ifd).setValue(new String(b, "ASCII"));
                        break;
                    }
                    case LONG: {
                        ((LongIfd)ifd).setValue(JPEGParser.readU32((DataInput)basdi));
                        break;
                    }
                    case RATIONAL: {
                        ((RationalIfd)ifd).setNumerator(JPEGParser.readU32((DataInput)basdi));
                        ((RationalIfd)ifd).setDenominator(JPEGParser.readU32((DataInput)basdi));
                        break;
                    }
                    case SLONG: {
                        ((SlongIfd)ifd).setValue(basdi.readInt());
                        break;
                    }
                    case SRATIONAL: {
                        ((SrationalIfd)ifd).setNumerator(basdi.readInt());
                        ((SrationalIfd)ifd).setDenominator(basdi.readInt());
                        break;
                    }
                }
            }
        }
    }

    private long reverseByteOrder(long x) {
        long b3 = (x & 0xFFFFFFFFFF000000L) >> 24;
        long b2 = (x & 0xFF0000L) >> 16;
        long b1 = (x & 0xFF00L) >> 8;
        long b0 = x & 0xFFL;
        return b3 | b2 | b1 | b0;
    }

    private int reverseU16ByteOrder(int x) {
        int b1 = (x & 0xFF00) >> 8;
        int b0 = (x & 0xFF) << 8;
        return b0 | b1;
    }

    private int reverseByteOrder(int x) {
        int b3 = (x & 0xFF000000) >> 24;
        int b2 = (x & 0xFF0000) >> 16;
        int b1 = (x & 0xFF00) >> 8;
        int b0 = x & 0xFF;
        return b3 | b2 | b1 | b0;
    }

    static {
        IFD_TYPE_CLASS_MAP.put(IfdType.BYTE, ByteIfd.class);
        IFD_TYPE_CLASS_MAP.put(IfdType.ASCII, AsciiIfd.class);
        IFD_TYPE_CLASS_MAP.put(IfdType.SHORT, ShortIfd.class);
        IFD_TYPE_CLASS_MAP.put(IfdType.LONG, LongIfd.class);
        IFD_TYPE_CLASS_MAP.put(IfdType.RATIONAL, RationalIfd.class);
        IFD_TYPE_CLASS_MAP.put(IfdType.UNDEFINED, UndefinedIfd.class);
        IFD_TYPE_CLASS_MAP.put(IfdType.SLONG, SlongIfd.class);
        IFD_TYPE_CLASS_MAP.put(IfdType.SRATIONAL, SrationalIfd.class);
    }

    public static enum ByteAlign {
        INTEL,
        MOTOROLA;

    }

    public static enum IfdType {
        BYTE(1),
        ASCII(2),
        SHORT(3),
        LONG(4),
        RATIONAL(5),
        UNDEFINED(7),
        SLONG(9),
        SRATIONAL(10);

        private static final Map<Integer, IfdType> lookup;
        private int code;

        private IfdType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static IfdType get(int code) {
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, IfdType>();
            for (IfdType s : EnumSet.allOf(IfdType.class)) {
                lookup.put(s.getCode(), s);
            }
        }
    }
}

