/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.jpeg.markers;

import com.apple.jingle.leghorn.image.jpeg.JPEGConstants;
import com.apple.jingle.leghorn.image.jpeg.JPEGParser;
import com.apple.jingle.leghorn.image.jpeg.Marker;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

public class App0Marker
extends Marker {
    String identifier;
    int majorVersion;
    int minorVersion;
    int unitsForXAndYDensity;
    int xDensity;
    int yDensity;
    int xThumbnail;
    int yThumbnail;
    byte[] rgbValuesForThumbnail;

    @Override
    public String toString() {
        return "App0Marker{identifier='" + this.identifier + '\'' + ", majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", unitsForXAndYDensity=" + this.unitsForXAndYDensity + ", xDensity=" + this.xDensity + ", yDensity=" + this.yDensity + ", xThumbnail=" + this.xThumbnail + ", yThumbnail=" + this.yThumbnail + ", rgbValuesForThumbnail=" + this.rgbValuesForThumbnail + '}';
    }

    @Nonnull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void parse(List<ValidationIssue> issues) throws IOException {
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(this.data, (long)this.data.length);
        byte[] b = new byte[5];
        basdi.readFully(b);
        this.identifier = new String(b, "ASCII");
        if (this.identifier.equals(JPEGConstants.JFIF_IDENTIFIER)) {
            this.majorVersion = basdi.readUnsignedByte();
            this.minorVersion = basdi.readUnsignedByte();
            this.unitsForXAndYDensity = basdi.readUnsignedByte();
            this.xDensity = JPEGParser.readU16((DataInput)basdi);
            this.yDensity = JPEGParser.readU16((DataInput)basdi);
            this.xThumbnail = basdi.readUnsignedByte();
            this.yThumbnail = basdi.readUnsignedByte();
            this.rgbValuesForThumbnail = new byte[3 * this.xThumbnail * this.yThumbnail];
            for (int i = 0; i < 3 * this.xThumbnail * this.yThumbnail; ++i) {
                this.rgbValuesForThumbnail[i] = basdi.readByte();
            }
        }
    }
}

