/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.jpeg;

import com.apple.jingle.leghorn.image.ImageDescription;
import com.apple.jingle.leghorn.image.jpeg.JPEGConstants;
import com.apple.jingle.leghorn.image.jpeg.Marker;
import com.apple.jingle.leghorn.image.jpeg.ParserState;
import com.apple.jingle.leghorn.image.jpeg.markers.App0Marker;
import com.apple.jingle.leghorn.image.jpeg.markers.App14Marker;
import com.apple.jingle.leghorn.image.jpeg.markers.App1Marker;
import com.apple.jingle.leghorn.image.jpeg.markers.App2Marker;
import com.apple.jingle.leghorn.image.jpeg.markers.StartOfFrameMarker;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class JPEGParser {
    private static final byte[] START_OF_IMAGE = new byte[]{-1, -40};
    private long position = 0L;
    private State state = State.UNINITIALIZED;
    private boolean isProbablyGood = true;
    private boolean canDescribe = false;
    private boolean isDone = false;
    private byte[] buffer;
    private ParserState parserState;
    private long providedFileSize = -1L;
    private List<ValidationIssue> issues = new ArrayList<ValidationIssue>();
    private List<Marker> markers = new ArrayList<Marker>();
    private ImageDescription description = new ImageDescription();
    protected static final Map<Integer, Class<? extends Marker>> TYPE_CLASS_MAP = new HashMap<Integer, Class<? extends Marker>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Collection<String> shortSet;
        if (args.length > 0) {
            shortSet = Arrays.asList(args);
        } else {
            shortSet = new HashSet();
            shortSet.add("/Users/renz/Documents/ExifRemovalExperiment/1pixel-Gray.jpg");
        }
        for (String f : shortSet) {
            try {
                File file = new File(f);
                try (FileInputStream fis = new FileInputStream(file);){
                    JPEGParser parser = new JPEGParser();
                    ParserState currentState = parser.initialize();
                    byte[] b = new byte[1024];
                    while (currentState.isGood() && !currentState.isDone() && parser.getValidationIssues().size() == 0) {
                        int bytesRead;
                        int totalBytesRead = 0;
                        int bytesToRead = currentState.getNumBytesToRead();
                        do {
                            if (bytesToRead == -1) {
                                bytesRead = fis.read(b);
                            } else {
                                int len = bytesToRead - totalBytesRead > b.length ? b.length : bytesToRead - totalBytesRead;
                                bytesRead = fis.read(b, 0, len);
                                totalBytesRead += bytesRead;
                                if (bytesRead == -1) {
                                    throw new IOException("This file is instructing me to read past the end of the file. This is a fatal error.");
                                }
                            }
                            currentState = parser.didRead(b, 0, bytesRead);
                        } while (totalBytesRead < bytesToRead && bytesRead != -1);
                    }
                    if (parser.canDescribe) {
                        System.out.println(parser.getDescription());
                    }
                    System.out.println(parser);
                    if (parser.getValidationIssues().size() == 0) continue;
                    System.out.println(parser.getValidationIssues());
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public ImageDescription getDescription() {
        return this.description;
    }

    public String toString() {
        return this.markers.toString();
    }

    public ParserState initialize() {
        if (this.state != State.UNINITIALIZED) {
            throw new UnsupportedOperationException("You are trying to initialize an initialized Parser.");
        }
        this.state = State.START_OF_IMAGE;
        this.isProbablyGood = true;
        this.canDescribe = false;
        this.isDone = false;
        this.parserState = new ParserState(0, 2, this.isProbablyGood, this.isDone, this.canDescribe);
        return this.parserState;
    }

    public ParserState initialize(long fileSize) {
        this.providedFileSize = fileSize;
        return this.initialize();
    }

    public ParserState didRead(byte[] b, int offset, int len) throws IOException {
        if (len == -1) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "We reached the end of the file before we thought we would. The image must be corrupt", MediaValidationCode.IMG_APPEARS_CORRUPT));
            this.parserState.setGood(false);
            return this.parserState;
        }
        if (len == 0 && this.parserState.getNumBytesToRead() != 0) {
            return this.parserState;
        }
        this.parserState.addBytesRead(len);
        this.position += (long)len;
        if (this.providedFileSize > -1L && this.position > this.providedFileSize) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Parser read past the file size provided. Something is wrong.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        byte[] bytesReceived = new byte[len];
        System.arraycopy(b, offset, bytesReceived, 0, len);
        if (this.state == State.SCAN_FOR_NEXT_MARKER) {
            int indexOfEOIMarker = this.findEOIMarker(bytesReceived, offset, len);
            if (indexOfEOIMarker != -1) {
                this.isDone = true;
                this.isProbablyGood = true;
                this.canDescribe = true;
                if (bytesReceived.length > indexOfEOIMarker + 2) {
                    this.isProbablyGood = false;
                    this.canDescribe = false;
                    this.issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "File has data after EOI Marker.", MediaValidationCode.IMG_APPEARS_CORRUPT));
                }
                this.parserState.set(0, 0, this.isProbablyGood, this.isDone, this.canDescribe);
            } else {
                this.parserState.set(0, -1, this.isProbablyGood, this.isDone, this.canDescribe);
            }
            return this.parserState;
        }
        if (this.parserState.getBytesRead() == this.parserState.getNumBytesToRead()) {
            byte[] finalBuffer = bytesReceived;
            if (this.buffer != null) {
                System.arraycopy(bytesReceived, 0, this.buffer, this.parserState.getBytesRead() - bytesReceived.length, bytesReceived.length);
                finalBuffer = this.buffer;
                this.buffer = null;
            }
            this.parserState.setBytesRead(0);
            if (this.state == State.START_OF_IMAGE) {
                return this.parseStartOfImage(finalBuffer);
            }
            if (this.state == State.MARKER_TYPE) {
                return this.parseMarkerType(finalBuffer);
            }
            if (this.state == State.MARKER_SIZE) {
                return this.parseMarkerSize(finalBuffer);
            }
            if (this.state == State.MARKER_DATA) {
                return this.parseMarkerData(finalBuffer);
            }
        } else {
            if (this.buffer == null) {
                this.buffer = new byte[this.parserState.getNumBytesToRead()];
            }
            System.arraycopy(bytesReceived, 0, this.buffer, this.parserState.getBytesRead() - bytesReceived.length, bytesReceived.length);
            return this.parserState;
        }
        this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "Entered an impossible state while parsing.", MediaValidationCode.IMG_UNKNOWN_ERROR));
        throw new IllegalStateException("You have entered an impossible state. Well done.");
    }

    private int findEOIMarker(byte[] b, int offset, int len) {
        for (int i = offset; i < len; ++i) {
            if (b[i] != -1 || len <= i + 1 || b[i + 1] != -39) continue;
            return i;
        }
        return -1;
    }

    private ParserState parseStartOfImage(byte[] b) {
        this.state = State.MARKER_TYPE;
        if (Arrays.equals(START_OF_IMAGE, b)) {
            return this.parserState.set(0, 2, this.isProbablyGood, this.isDone, this.canDescribe);
        }
        this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "This file does not start with a start of image marker.", MediaValidationCode.IMG_CONTAINER_INCOMPATIBLE));
        this.isProbablyGood = false;
        return this.parserState.set(0, 2, false, this.isDone, this.canDescribe);
    }

    private ParserState parseMarkerType(byte[] b) throws IOException {
        this.state = State.MARKER_SIZE;
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(b, (long)b.length);
        int type = JPEGParser.readU16((DataInput)basdi);
        if (JPEGConstants.STAND_ALONE_MARKER_LIST.contains(type)) {
            this.state = State.MARKER_TYPE;
        }
        if (type == 65498) {
            this.state = State.SCAN_FOR_NEXT_MARKER;
            this.parserState.set(0, -1, this.isProbablyGood, this.isDone, this.canDescribe);
            return this.parserState;
        }
        Marker currentMarker = null;
        if (TYPE_CLASS_MAP.containsKey(type)) {
            try {
                currentMarker = TYPE_CLASS_MAP.get(type).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            currentMarker = new Marker();
        }
        currentMarker.setType(type);
        this.markers.add(currentMarker);
        return this.parserState.set(0, 2, this.isProbablyGood, this.isDone, this.canDescribe);
    }

    private ParserState parseMarkerSize(byte[] b) throws IOException {
        this.state = State.MARKER_DATA;
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(b, (long)b.length);
        int size = JPEGParser.readU16((DataInput)basdi);
        this.getCurrentMarker().setSize(size);
        return this.parserState.set(0, this.getCurrentMarker().getSize() - 2, this.isProbablyGood, this.isDone, this.canDescribe);
    }

    private ParserState parseMarkerData(byte[] b) throws IOException {
        this.state = State.MARKER_TYPE;
        Marker currentMarker = this.getCurrentMarker();
        currentMarker.setData(b);
        currentMarker.parse(this.issues);
        if (currentMarker instanceof StartOfFrameMarker) {
            this.canDescribe = true;
            int height = ((StartOfFrameMarker)currentMarker).getImageHeight();
            int width = ((StartOfFrameMarker)currentMarker).getImageWidth();
            int samplePrecision = ((StartOfFrameMarker)currentMarker).getSamplePrecision();
            this.description = new ImageDescription(height, width, samplePrecision);
            String colorSpace = this.determineColorspace((StartOfFrameMarker)currentMarker, this.description);
            this.description.setColorSpace(colorSpace);
        }
        if (1 == this.markers.size() && currentMarker instanceof App0Marker && !JPEGConstants.JFIF_IDENTIFIER.equals(((App0Marker)currentMarker).getIdentifier())) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "JFIF signature does not match.", MediaValidationCode.IMG_CONTAINER_INCOMPATIBLE));
        }
        return this.parserState.set(0, 2, this.isProbablyGood, this.isDone, this.canDescribe);
    }

    private String determineColorspace(StartOfFrameMarker startOfFrameMarker, ImageDescription description) {
        List<StartOfFrameMarker.Component> components;
        String colorspace = "";
        if (startOfFrameMarker.getNumberOfComponents() == 1) {
            return "Grayscale";
        }
        if (this.hasApp14Marker()) {
            int transformFlag = this.getApp14Marker().getTransform();
            if (transformFlag == 2) {
                return "CMYK";
            }
            if (transformFlag == 1) {
                return "RGB";
            }
            if (startOfFrameMarker.getNumberOfComponents() == 3) {
                return "RGB";
            }
            return "CMYK";
        }
        if (this.hasApp0Marker() && this.hasApp2Marker()) {
            return "RGB";
        }
        if (startOfFrameMarker.getNumberOfComponents() == 2) {
            description.setAlphaChannel(true);
            return "Grayscale";
        }
        if (startOfFrameMarker.getNumberOfComponents() == 3) {
            components = startOfFrameMarker.getComponents();
            for (StartOfFrameMarker.Component component : components) {
                if (component.getIdentifier() <= 3) continue;
                for (StartOfFrameMarker.Component c : components) {
                    colorspace = colorspace + String.valueOf((char)c.getIdentifier());
                }
                return colorspace;
            }
        }
        if (startOfFrameMarker.getNumberOfComponents() == 4) {
            components = startOfFrameMarker.getComponents();
            for (StartOfFrameMarker.Component component : components) {
                if (component.getIdentifier() <= 4) continue;
                for (StartOfFrameMarker.Component c : components) {
                    colorspace = colorspace + String.valueOf((char)c.getIdentifier());
                }
                return colorspace;
            }
        }
        if (startOfFrameMarker.getNumberOfComponents() == 3) {
            return "RGB";
        }
        if (startOfFrameMarker.getNumberOfComponents() == 4) {
            return "CMYK";
        }
        return colorspace;
    }

    private boolean hasApp0Marker() {
        for (Marker m : this.markers) {
            if (!(m instanceof App0Marker)) continue;
            return true;
        }
        return false;
    }

    private boolean hasApp2Marker() {
        for (Marker m : this.markers) {
            if (!(m instanceof App2Marker)) continue;
            return true;
        }
        return false;
    }

    private boolean hasApp14Marker() {
        for (Marker m : this.markers) {
            if (!(m instanceof App14Marker)) continue;
            return true;
        }
        return false;
    }

    private App14Marker getApp14Marker() {
        for (Marker m : this.markers) {
            if (!(m instanceof App14Marker)) continue;
            return (App14Marker)m;
        }
        return new App14Marker();
    }

    private Marker getCurrentMarker() {
        return this.markers.get(this.markers.size() - 1);
    }

    public static int readU16(DataInput input) throws IOException {
        byte[] bytesFor16 = new byte[2];
        input.readFully(bytesFor16);
        BigInteger u16BI = new BigInteger(1, bytesFor16);
        return u16BI.intValue();
    }

    public static long readU32(DataInput input) throws IOException {
        byte[] bytesFor32 = new byte[4];
        input.readFully(bytesFor32);
        BigInteger u32BI = new BigInteger(1, bytesFor32);
        return u32BI.longValue();
    }

    public static String readFourCC(DataInput input) throws IOException {
        byte[] bytesForFourCC = new byte[4];
        input.readFully(bytesForFourCC);
        return new String(bytesForFourCC, "ISO8859_1");
    }

    public static String readNullTerminatedString(DataInput input) throws IOException {
        byte b;
        StringBuilder sb = new StringBuilder();
        do {
            if ((b = input.readByte()) == 0) continue;
            sb.append(b);
        } while (b != 0);
        return sb.toString();
    }

    public void always(int a, int b) {
        if (a != b) {
            throw new IllegalArgumentException("a(" + a + ") != b(" + b + ")");
        }
    }

    public List<ValidationIssue> getValidationIssues() {
        return this.issues;
    }

    public boolean canDescribe() {
        return this.parserState.isCanDescribe();
    }

    static {
        TYPE_CLASS_MAP.put(65504, App0Marker.class);
        TYPE_CLASS_MAP.put(65505, App1Marker.class);
        TYPE_CLASS_MAP.put(65506, App2Marker.class);
        TYPE_CLASS_MAP.put(65518, App14Marker.class);
        TYPE_CLASS_MAP.put(65472, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65479, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65487, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65478, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65486, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65477, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65485, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65475, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65483, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65473, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65481, StartOfFrameMarker.class);
        TYPE_CLASS_MAP.put(65474, StartOfFrameMarker.class);
    }

    public static enum State {
        UNINITIALIZED,
        START_OF_IMAGE,
        MARKER_TYPE,
        MARKER_SIZE,
        MARKER_DATA,
        SCAN_FOR_NEXT_MARKER,
        END_OF_IMAGE;

    }
}

