/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.gif;

import com.apple.jingle.leghorn.image.ImageDescription;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GIFParser {
    private ImageDescription description = null;
    private List<ValidationIssue> issues = new ArrayList<ValidationIssue>();

    public ImageDescription getDescription() {
        return this.description;
    }

    public List<ValidationIssue> getValidationIssues() {
        return this.issues;
    }

    public void parse(BufferedInputStream bis) {
        try {
            if (bis == null || bis.available() < 13) {
                this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "Image does not have valid header", MediaValidationCode.IMG_APPEARS_CORRUPT));
                return;
            }
            bis.skip(6L);
            int width = bis.read() | bis.read() << 8;
            int height = bis.read() | bis.read() << 8;
            this.description = new ImageDescription();
            this.description.setWidth(width);
            this.description.setHeight(height);
        }
        catch (IOException ioException) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "Unexpected error occured while parsing image", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
    }

    public void parse(SeekableDataInput sdi) {
        try {
            if (sdi == null || sdi.length() < 13L) {
                this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "Image does not have valid header", MediaValidationCode.IMG_APPEARS_CORRUPT));
                return;
            }
            sdi.seek(6L);
            int width = sdi.readUnsignedByte() | sdi.readUnsignedByte() << 8;
            int height = sdi.readUnsignedByte() | sdi.readUnsignedByte() << 8;
            this.description = new ImageDescription();
            this.description.setWidth(width);
            this.description.setHeight(height);
        }
        catch (IOException ioException) {
            this.issues.add(new ValidationIssue(ValidationIssue.Severity.FATAL, "Unexpected error occured while parsing image", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
    }
}

