/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.image.ImageDescription;
import com.apple.jingle.leghorn.image.beans.Image;
import com.apple.jingle.leghorn.image.beans.ImageDocument;
import com.apple.jingle.leghorn.image.beans.ImageEntry;
import com.apple.jingle.leghorn.image.gif.GIFParser;
import com.apple.jingle.leghorn.image.jpeg.JPEGParser;
import com.apple.jingle.leghorn.image.jpeg.ParserState;
import com.apple.jingle.leghorn.image.png.PNGParser;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import org.apache.xmlbeans.XmlCursor;

public class ImageDescriptionGenerator {
    public static ImageDocument generateDescription(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        String utiTypeName = type.getUTITypeName();
        if (utiTypeName.equals("public.jpeg")) {
            return ImageDescriptionGenerator.generateJPEGDescription(ImageDescriptionGenerator.parseJPEG(sdi));
        }
        if (utiTypeName.equals("public.png")) {
            return ImageDescriptionGenerator.generatePNGDescription(ImageDescriptionGenerator.parsePNG(sdi));
        }
        if (utiTypeName.equals("public.tiff")) {
            return ImageDescriptionGenerator.generateTIFFDescription();
        }
        if (utiTypeName.equals("public.gif")) {
            return ImageDescriptionGenerator.generateGIFDescription(ImageDescriptionGenerator.parseGIF(sdi));
        }
        return null;
    }

    public static ImageEntry generateDescription(SeekableDataInput sdi, ContainerType type, ImageEntry entry) throws IOException {
        String utiTypeName = type.getUTITypeName();
        if (utiTypeName.equals("public.jpeg")) {
            return ImageDescriptionGenerator.generateJPEGDescription(ImageDescriptionGenerator.parseJPEG(sdi), sdi.getFileName(), entry);
        }
        if (utiTypeName.equals("public.png")) {
            return ImageDescriptionGenerator.generatePNGDescription(ImageDescriptionGenerator.parsePNG(sdi), sdi.getFileName(), entry);
        }
        if (utiTypeName.equals("public.gif")) {
            return ImageDescriptionGenerator.generateGIFDescription(ImageDescriptionGenerator.parseGIF(sdi), sdi.getFileName(), entry);
        }
        return null;
    }

    public static ImageDocument generateDescription(BufferedInputStream bis, ContainerType type, ValidationListener listener) throws IOException {
        String utiTypeName = type.getUTITypeName();
        if (utiTypeName.equals("public.jpeg")) {
            return ImageDescriptionGenerator.generateJPEGDescription(ImageDescriptionGenerator.parseJPEG(bis));
        }
        if (utiTypeName.equals("public.png")) {
            return ImageDescriptionGenerator.generatePNGDescription(ImageDescriptionGenerator.parsePNG(bis));
        }
        if (utiTypeName.equals("public.tiff")) {
            return ImageDescriptionGenerator.generateTIFFDescription();
        }
        if (utiTypeName.equals("public.gif")) {
            return ImageDescriptionGenerator.generateGIFDescription(ImageDescriptionGenerator.parseGIF(bis));
        }
        return null;
    }

    public static JPEGParser parseJPEG(SeekableDataInput sdi) throws IOException {
        sdi.seek(0L);
        JPEGParser parser = new JPEGParser();
        ParserState currentState = parser.initialize();
        byte[] b = new byte[1000];
        while (currentState.isGood() && !currentState.isDone()) {
            int bytesRead;
            int totalBytesRead = 0;
            int bytesToRead = currentState.getNumBytesToRead();
            do {
                if (bytesToRead == -1) {
                    long howManyBytesToRead;
                    long l = howManyBytesToRead = sdi.length() - sdi.getFilePointer() < (long)b.length ? sdi.length() - sdi.getFilePointer() : (long)b.length;
                    if (howManyBytesToRead < (long)b.length) {
                        sdi.readFully(b, 0, (int)howManyBytesToRead);
                    }
                    bytesRead = bytesToRead;
                } else {
                    int len = bytesToRead - totalBytesRead > b.length ? b.length : bytesToRead - totalBytesRead;
                    sdi.readFully(b, 0, len);
                    bytesRead = len;
                    totalBytesRead += bytesRead;
                    if (bytesRead == -1) {
                        throw new IOException("This file is instructing me to read past the end of the file. This is a fatal error.");
                    }
                }
                currentState = parser.didRead(b, 0, bytesRead);
            } while (totalBytesRead < bytesToRead && bytesRead != -1);
        }
        return parser;
    }

    public static JPEGParser parseJPEG(BufferedInputStream bis) throws IOException {
        JPEGParser parser = new JPEGParser();
        ParserState currentState = parser.initialize();
        byte[] b = new byte[1000];
        while (currentState.isGood() && !currentState.isDone()) {
            int bytesRead;
            int totalBytesRead = 0;
            int bytesToRead = currentState.getNumBytesToRead();
            do {
                if (bytesToRead == -1) {
                    bytesRead = bis.read(b);
                } else {
                    int len = bytesToRead - totalBytesRead > b.length ? b.length : bytesToRead - totalBytesRead;
                    bytesRead = bis.read(b, 0, len);
                    totalBytesRead += bytesRead;
                    if (bytesRead == -1) {
                        throw new IOException("This file is instructing me to read past the end of the file. This is a fatal error.");
                    }
                }
                currentState = parser.didRead(b, 0, bytesRead);
            } while (totalBytesRead < bytesToRead && bytesRead != -1);
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JPEGParser parseJPEG(URI u) throws IOException {
        JPEGParser parser = new JPEGParser();
        try (SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)u);){
            ParserState currentState = parser.initialize();
            byte[] b = new byte[1000];
            while (currentState.isGood() && !currentState.isDone()) {
                int bytesRead;
                int totalBytesRead = 0;
                int bytesToRead = currentState.getNumBytesToRead();
                do {
                    if (bytesToRead == -1) {
                        sdi.readFully(b);
                        bytesRead = bytesToRead;
                    } else {
                        int len = bytesToRead - totalBytesRead > b.length ? b.length : bytesToRead - totalBytesRead;
                        sdi.readFully(b, 0, len);
                        bytesRead = bytesToRead;
                        totalBytesRead += bytesRead;
                        if (bytesRead == -1) {
                            throw new IOException("This file (" + u.getPath() + ") is instructing me to read past the end of the file. This is a fatal error.");
                        }
                    }
                    currentState = parser.didRead(b, 0, bytesRead);
                } while (totalBytesRead < bytesToRead && bytesRead != -1);
            }
        }
        return parser;
    }

    public static PNGParser parsePNG(SeekableDataInput sdi) throws IOException {
        sdi.seek(0L);
        PNGParser parser = new PNGParser(true);
        com.apple.jingle.leghorn.image.png.ParserState currentState = parser.initialize();
        byte[] b = new byte[1000];
        while (currentState.isGood() && !currentState.isDone()) {
            int bytesRead;
            long bytesSkipped = 0L;
            while (bytesSkipped < (long)currentState.getNumBytesToSkip()) {
                bytesSkipped = sdi.skipBytes((int)((long)currentState.getNumBytesToSkip() - bytesSkipped));
            }
            int totalBytesRead = 0;
            do {
                bytesRead = currentState.getNumBytesToRead() - currentState.getBytesRead() > b.length ? b.length : currentState.getNumBytesToRead() - currentState.getBytesRead();
                sdi.readFully(b, 0, bytesRead);
                totalBytesRead += bytesRead;
                if (bytesRead != -1) continue;
                throw new IOException("This file is instructing me to read past the end of the file. This is a fatal error.");
            } while (totalBytesRead < (currentState = parser.didRead(b, 0, bytesRead)).getNumBytesToRead() && currentState.isGood());
        }
        return parser;
    }

    public static PNGParser parsePNG(BufferedInputStream bis) throws IOException {
        PNGParser parser = new PNGParser(true);
        com.apple.jingle.leghorn.image.png.ParserState currentState = parser.initialize();
        byte[] b = new byte[1000];
        while (currentState.isGood() && !currentState.isDone()) {
            int bytesRead;
            long bytesSkipped = 0L;
            while (bytesSkipped < (long)currentState.getNumBytesToSkip()) {
                bytesSkipped = bis.skip((long)currentState.getNumBytesToSkip() - bytesSkipped);
            }
            int totalBytesRead = 0;
            do {
                int len = currentState.getNumBytesToRead() - currentState.getBytesRead() > b.length ? b.length : currentState.getNumBytesToRead() - currentState.getBytesRead();
                bytesRead = bis.read(b, 0, len);
                totalBytesRead += bytesRead;
                if (bytesRead != -1) continue;
                throw new IOException("This file is instructing me to read past the end of the file. This is a fatal error.");
            } while (totalBytesRead < (currentState = parser.didRead(b, 0, bytesRead)).getNumBytesToRead() && currentState.isGood());
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PNGParser parsePNG(URI u) throws IOException {
        PNGParser parser = new PNGParser(true);
        try (SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)u);){
            com.apple.jingle.leghorn.image.png.ParserState currentState = parser.initialize();
            byte[] b = new byte[1000];
            while (currentState.isGood() && !currentState.isDone()) {
                int bytesRead;
                long bytesSkipped = 0L;
                while (bytesSkipped < (long)currentState.getNumBytesToSkip()) {
                    bytesSkipped = sdi.skipBytes((int)((long)currentState.getNumBytesToSkip() - bytesSkipped));
                }
                int totalBytesRead = 0;
                do {
                    bytesRead = currentState.getNumBytesToRead() - currentState.getBytesRead() > b.length ? b.length : currentState.getNumBytesToRead() - currentState.getBytesRead();
                    sdi.readFully(b, 0, bytesRead);
                    totalBytesRead += bytesRead;
                    if (bytesRead != -1) continue;
                    throw new IOException("This file (" + u.getPath() + ") is instructing me to read past the end of the file. This is a fatal error.");
                } while (totalBytesRead < (currentState = parser.didRead(b, 0, bytesRead)).getNumBytesToRead() && currentState.isGood());
            }
        }
        return parser;
    }

    public static ImageDocument generateJPEGDescription(JPEGParser parser) throws IOException {
        ImageDocument doc = ImageDocument.Factory.newInstance();
        Image image = doc.addNewImage();
        ImageDescriptionGenerator.insertComments(image);
        image.addNewHeight().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getHeight()));
        image.addNewWidth().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getWidth()));
        image.addNewSamplePrecision().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getSamplePrecision()));
        image.addNewColorSpace().setStringValue(parser.getDescription().getColorSpace());
        image.addNewAlphaChannel().setBooleanValue(parser.getDescription().getAlphaChannel());
        image.addNewColorMap().setBooleanValue(parser.getDescription().getColorMap());
        return doc;
    }

    public static ImageEntry generateJPEGDescription(JPEGParser parser, String filename, ImageEntry entry) throws IOException {
        Image image = entry.addNewImage();
        image.setFilename(filename);
        ImageDescriptionGenerator.insertComments(image);
        image.addNewHeight().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getHeight()));
        image.addNewWidth().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getWidth()));
        image.addNewSamplePrecision().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getSamplePrecision()));
        image.addNewColorSpace().setStringValue(parser.getDescription().getColorSpace());
        image.addNewAlphaChannel().setBooleanValue(parser.getDescription().getAlphaChannel());
        image.addNewColorMap().setBooleanValue(parser.getDescription().getColorMap());
        return entry;
    }

    public static ImageDocument generatePNGDescription(PNGParser parser) throws IOException {
        ImageDocument doc = ImageDocument.Factory.newInstance();
        Image image = doc.addNewImage();
        ImageDescriptionGenerator.insertComments(image);
        image.addNewHeight().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getHeight()));
        image.addNewWidth().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getWidth()));
        image.addNewSamplePrecision().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getSamplePrecision()));
        image.addNewColorSpace().setStringValue(parser.getDescription().getColorSpace());
        image.addNewAlphaChannel().setBooleanValue(parser.getDescription().getAlphaChannel());
        image.addNewColorMap().setBooleanValue(parser.getDescription().getColorMap());
        return doc;
    }

    public static ImageEntry generatePNGDescription(PNGParser parser, String filename, ImageEntry entry) throws IOException {
        Image image = entry.addNewImage();
        image.setFilename(filename);
        ImageDescriptionGenerator.insertComments(image);
        image.addNewHeight().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getHeight()));
        image.addNewWidth().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getWidth()));
        image.addNewSamplePrecision().setBigIntegerValue(BigInteger.valueOf(parser.getDescription().getSamplePrecision()));
        image.addNewColorSpace().setStringValue(parser.getDescription().getColorSpace());
        image.addNewAlphaChannel().setBooleanValue(parser.getDescription().getAlphaChannel());
        image.addNewColorMap().setBooleanValue(parser.getDescription().getColorMap());
        return entry;
    }

    public static ImageDocument generateTIFFDescription() throws IOException {
        ImageDocument doc = ImageDocument.Factory.newInstance();
        Image image = doc.addNewImage();
        ImageDescriptionGenerator.insertComments(image);
        return doc;
    }

    private static void insertComments(Image image) {
        XmlCursor cursor = image.newCursor();
        cursor.insertComment("Generated by the FoghornLeghorn ImageDescriptionGenerator, version " + Configuration.getVersion());
        cursor.insertChars("\n");
    }

    public static GIFParser parseGIF(SeekableDataInput seekableDataInput) {
        GIFParser gifParser = new GIFParser();
        gifParser.parse(seekableDataInput);
        return gifParser;
    }

    public static GIFParser parseGIF(BufferedInputStream bufferedInputStream) {
        GIFParser gifParser = new GIFParser();
        gifParser.parse(bufferedInputStream);
        return gifParser;
    }

    public static ImageDocument generateGIFDescription(GIFParser parser) {
        ImageDocument doc = ImageDocument.Factory.newInstance();
        Image image = doc.addNewImage();
        ImageDescriptionGenerator.insertComments(image);
        ImageDescription description = parser.getDescription();
        if (description != null) {
            image.addNewWidth().setBigIntegerValue(BigInteger.valueOf(description.getWidth()));
            image.addNewHeight().setBigIntegerValue(BigInteger.valueOf(description.getHeight()));
        }
        return doc;
    }

    public static ImageEntry generateGIFDescription(GIFParser parser, String filename, ImageEntry entry) {
        Image image = entry.addNewImage();
        image.setFilename(filename);
        ImageDescriptionGenerator.insertComments(image);
        ImageDescription description = parser.getDescription();
        if (description != null) {
            image.addNewWidth().setBigIntegerValue(BigInteger.valueOf(description.getWidth()));
            image.addNewHeight().setBigIntegerValue(BigInteger.valueOf(description.getHeight()));
        }
        return entry;
    }
}

