/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image;

import com.apple.jingle.leghorn.image.ImageDescription;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ImageDescriptionDeserializer {
    public static ImageDescription deserialize(String imageDescriptionXml) throws XmlException, ParserConfigurationException, SAXException, IOException {
        return ImageDescriptionDeserializer.deserialize(XMLUtil.parseXML((String)imageDescriptionXml));
    }

    private static ImageDescription deserialize(Document document) throws XmlException {
        ImageDescription imageDescription = new ImageDescription();
        if (document != null) {
            XmlObject parsedDescription = XmlObject.Factory.parse(document);
            String heightValue = ImageDescriptionDeserializer.valueForPath(parsedDescription, "/image/height");
            imageDescription.setHeight(Integer.parseInt(heightValue));
            String widthValue = ImageDescriptionDeserializer.valueForPath(parsedDescription, "/image/width");
            imageDescription.setWidth(Integer.parseInt(widthValue));
            String samplePrecisionValue = ImageDescriptionDeserializer.valueForPath(parsedDescription, "/image/sample_precision");
            imageDescription.setSamplePrecision(Integer.parseInt(samplePrecisionValue));
            String colorSpaceValue = ImageDescriptionDeserializer.valueForPath(parsedDescription, "/image/color_space");
            imageDescription.setColorSpace(colorSpaceValue);
            String alphaChannelValue = ImageDescriptionDeserializer.valueForPath(parsedDescription, "/image/alpha_channel");
            imageDescription.setAlphaChannel(Boolean.parseBoolean(alphaChannelValue));
            String colorMapValue = ImageDescriptionDeserializer.valueForPath(parsedDescription, "/image/color_map");
            imageDescription.setColorMap(Boolean.parseBoolean(colorMapValue));
        }
        return imageDescription;
    }

    private static String valueForPath(XmlObject parsedDescription, String path) throws XmlException {
        String value = XMLUtil.textValueAtXPath((XmlObject)parsedDescription, (String)path);
        if (value == null) {
            throw new XmlException(String.format("No value for path [%s]", path));
        }
        return value;
    }
}

