/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.matcher;

import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationInfo;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.impl.ValidationsCollector;
import com.apple.jingle.leghorn.fileformat.matcher.MagicMatcherSet;
import com.apple.jingle.leghorn.fileformat.matcher.Matcher;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MatcherSet
implements Matcher,
MagicMatcherSet {
    protected List<Matcher> matchers = new ArrayList<Matcher>();
    protected long offset = 0L;
    protected long bytesNeeded = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(File f) throws IOException {
        try (FileSeekableDataInput sdi = null;){
            sdi = new FileSeekableDataInput(f);
            boolean bl = this.matches((SeekableDataInput)sdi);
            return bl;
        }
    }

    public boolean matches(SeekableDataInput sdi) throws IOException {
        return this.matches(sdi, null);
    }

    @Override
    public boolean matches(SeekableDataInput sdi, ValidationListener listener) throws IOException {
        if (this.matchers.size() == 0) {
            return true;
        }
        if (!this.isFollows()) {
            return true;
        }
        ValidationsCollector descendantListenerCollector = new ValidationsCollector();
        boolean matches = false;
        for (Matcher m : this.matchers) {
            matches |= m.matches(sdi, descendantListenerCollector);
        }
        if (!matches && listener != null) {
            listener.error(this.getCompoundError(descendantListenerCollector));
        }
        return matches;
    }

    private ValidationError getCompoundError(ValidationsCollector descendantListenerCollector) {
        String message = "Could not verify, expected: ";
        long position = -1L;
        Iterator<ValidationInfo> i = descendantListenerCollector.getValidations().iterator();
        while (i.hasNext()) {
            ValidationInfo info = i.next();
            message = message + info.getUserString();
            if (i.hasNext()) {
                message = message + " | ";
            }
            position = Math.max(position, info.getPosition());
        }
        return new ValidationError(message, position);
    }

    protected boolean isFollows() {
        return true;
    }

    public List<Matcher> getMatchers() {
        return this.matchers;
    }

    @Override
    public void addMatcher(Matcher matcher) {
        this.matchers.add(matcher);
        if (matcher instanceof MagicMatcherSet) {
            MagicMatcherSet mms = (MagicMatcherSet)((Object)matcher);
            if (mms.getOffset() < this.offset || this.bytesNeeded < (long)mms.getBytesNeeded()) {
                this.bytesNeeded += Math.min(this.offset - mms.getOffset(), 0L);
                this.offset = mms.getOffset();
                this.bytesNeeded += Math.min((long)mms.getBytesNeeded() - this.bytesNeeded, 0L);
            } else if (this.offset == -1L) {
                this.bytesNeeded = mms.getBytesNeeded();
                this.offset = mms.getOffset();
            }
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public boolean matches(byte b, long offset) {
        if (this.matchers.size() == 0) {
            return true;
        }
        boolean matches = false;
        boolean inRange = true;
        for (MagicMatcherSet magicMatcherSet : this.matchers) {
            if (offset >= magicMatcherSet.getOffset() && offset < magicMatcherSet.getOffset() + (long)magicMatcherSet.getBytesNeeded()) {
                matches |= magicMatcherSet.matches(b, offset);
                continue;
            }
            inRange = false;
            Logger.getAnonymousLogger().info(offset + " not in range [" + magicMatcherSet.getOffset() + "," + (magicMatcherSet.getOffset() + (long)magicMatcherSet.getBytesNeeded()) + "] for " + magicMatcherSet);
        }
        return !inRange || matches;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public int getBytesNeeded() {
        return (int)this.bytesNeeded;
    }
}

