/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.matcher;

import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.matcher.MagicMatcherSet;
import com.apple.jingle.leghorn.fileformat.matcher.Matcher;
import com.apple.jingle.leghorn.fileformat.matcher.MatcherSet;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.xml.sax.Attributes;

public class MagicMatcher
extends MatcherSet
implements Matcher,
MagicMatcherSet,
ObjectCreationFactory {
    protected static final Map<String, MagicMatcherType> MATCHER_TYPES;
    protected static final ByteComparator MATCHER_OP_LT;
    protected static final ByteComparator MATCHER_OP_GT;
    protected static final ByteComparator MATCHER_OP_EQ;
    protected static final ByteComparator MATCHER_OP_AND;
    protected static final ByteComparator MATCHER_OP_OR;
    private Digester digester;
    protected long offset;
    protected MagicMatcherType type;
    protected String typeop;
    protected byte[] testData = new byte[0];
    protected String message;
    protected ByteComparator testComparator = MATCHER_OP_EQ;
    protected boolean follows = true;

    @Override
    public boolean matches(SeekableDataInput sdi) throws IOException {
        return this.matches(sdi, null);
    }

    @Override
    public boolean matches(SeekableDataInput sdi, ValidationListener listener) throws IOException {
        boolean truth = false;
        sdi.seek(this.offset);
        int byteCount = this.testData.length;
        byte[] bytes = new byte[byteCount];
        try {
            sdi.readFully(bytes);
        }
        catch (EOFException endOfFile) {
            if (listener != null) {
                listener.error(this.createValidationError());
            }
            return false;
        }
        truth = this.testComparator.isValid(bytes, this.testData);
        if (!truth && listener != null) {
            listener.error(this.createValidationError());
        }
        return truth && super.matches(sdi, listener);
    }

    @Override
    public boolean matches(byte b, long matcherOffset) {
        int localOffset = (int)(matcherOffset - this.offset);
        if (localOffset >= this.testData.length) {
            return false;
        }
        boolean matches = this.testComparator.isValid(new byte[]{b}, new byte[]{this.testData[localOffset]});
        Logger.getAnonymousLogger().info(this + " does " + (matches ? "" : "NOT ") + "match at " + matcherOffset + " with byte: " + Integer.toHexString(b));
        return matches;
    }

    @Override
    public int getBytesNeeded() {
        return this.testData.length + super.getBytesNeeded();
    }

    private ValidationError createValidationError() {
        ValidationError error = new ValidationError(this.message, this.offset);
        return error;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public MagicMatcherType getMagicMatcherType() {
        return this.type;
    }

    public String getType() {
        return this.type.type;
    }

    public void setType(String type) {
        if (type == null || type.trim().equals("")) {
            throw new IllegalArgumentException("Empty type is not allowed.");
        }
        this.type = MATCHER_TYPES.get(type.toLowerCase());
    }

    public String getTypeop() {
        return this.typeop;
    }

    public void setTypeop(String typeop) {
        this.typeop = typeop;
    }

    public byte[] getTestData() {
        return this.testData;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTest(String testDataString) {
        if (testDataString == null || testDataString.trim().equals("")) {
            throw new IllegalArgumentException("testDataString is null for " + this);
        }
        switch (testDataString.charAt(0)) {
            case '=': {
                this.testComparator = MATCHER_OP_EQ;
                testDataString = testDataString.substring(1);
                break;
            }
            case '>': {
                this.testComparator = MATCHER_OP_GT;
                testDataString = testDataString.substring(1);
                break;
            }
            case '<': {
                this.testComparator = MATCHER_OP_LT;
                testDataString = testDataString.substring(1);
                break;
            }
            case '&': {
                this.testComparator = MATCHER_OP_AND;
                testDataString = testDataString.substring(1);
                break;
            }
            case '^': {
                this.testComparator = MATCHER_OP_OR;
                testDataString = testDataString.substring(1);
            }
        }
        if (this.type != null && this.type.isNumeric()) {
            if (testDataString.startsWith("0x")) {
                this.testData = MagicMatcher.readHex(testDataString.substring(2));
            } else if (testDataString.startsWith("0")) {
                this.testData = MagicMatcher.readOctal(testDataString.substring(1));
            } else {
                BigInteger bi = new BigInteger(testDataString, 10);
                this.testData = bi.toByteArray();
            }
        } else {
            try {
                this.testData = testDataString.getBytes("ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Cannot parse: " + testDataString + " as ASCII");
            }
        }
    }

    @Override
    public boolean isFollows() {
        return this.follows;
    }

    public void setFollows(boolean follows) {
        this.follows = follows;
    }

    public void setTypeTest(String type, String test) {
        this.setType(type);
        this.setTest(test);
    }

    @Override
    public Object createObject(Attributes attributes) throws Exception {
        MagicMatcher mm = new MagicMatcher();
        Logger.getAnonymousLogger().fine("digester.peek: " + this.digester.peek() + " adding " + mm + "; attrs=" + attributes.getValue("message"));
        ((Matcher)this.digester.peek()).addMatcher(mm);
        return mm;
    }

    @Override
    public Digester getDigester() {
        return this.digester;
    }

    @Override
    public void setDigester(Digester digester) {
        this.digester = digester;
    }

    public static byte[] readHex(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bts;
    }

    public static byte[] readOctal(String testDataString) {
        return new byte[0];
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static {
        MATCHER_OP_LT = new ByteComparator(){

            @Override
            public boolean isValid(byte[] b1, byte[] b2) {
                throw new RuntimeException("Can't compare <");
            }

            public String toString() {
                return "ByteComparator: <";
            }
        };
        MATCHER_OP_GT = new ByteComparator(){

            @Override
            public boolean isValid(byte[] b1, byte[] b2) {
                throw new RuntimeException("Can't compare >");
            }

            public String toString() {
                return "ByteComparator: >";
            }
        };
        MATCHER_OP_EQ = new ByteComparator(){

            @Override
            public boolean isValid(byte[] b1, byte[] b2) {
                return Arrays.equals(b1, b2);
            }

            public String toString() {
                return "ByteComparator: ==";
            }
        };
        MATCHER_OP_AND = new ByteComparator(){

            @Override
            public boolean isValid(byte[] b1, byte[] b2) {
                if (b1 == null || b2 == null) {
                    throw new IllegalArgumentException("Can't compare nulls");
                }
                if (b1.length != b2.length) {
                    return false;
                }
                for (int i = 0; i < b1.length; ++i) {
                    if ((b1[i] & b2[i]) == b2[i]) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return "ByteComparator: AND";
            }
        };
        MATCHER_OP_OR = new ByteComparator(){

            @Override
            public boolean isValid(byte[] b1, byte[] b2) {
                if (b1 == null || b2 == null) {
                    throw new IllegalArgumentException("Can't compare nulls");
                }
                if (b1.length != b2.length) {
                    return false;
                }
                for (int i = 0; i < b1.length; ++i) {
                    if ((b1[i] | b2[i]) == b2[i]) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return "ByteComparator: OR";
            }
        };
        MATCHER_TYPES = new HashMap<String, MagicMatcherType>();
        MATCHER_TYPES.put("byte", new MagicMatcherType("byte", 1, ByteOrder.nativeOrder()));
        MATCHER_TYPES.put("short", new MagicMatcherType("short", 2, ByteOrder.nativeOrder()));
        MATCHER_TYPES.put("long", new MagicMatcherType("long", 4, ByteOrder.nativeOrder()));
        MATCHER_TYPES.put("string", new MagicMatcherType("string", -1, ByteOrder.BIG_ENDIAN));
        MATCHER_TYPES.put("date", null);
        MATCHER_TYPES.put("ldate", null);
        MATCHER_TYPES.put("beshort", new MagicMatcherType("beshort", 2, ByteOrder.BIG_ENDIAN));
        MATCHER_TYPES.put("belong", new MagicMatcherType("belong", 4, ByteOrder.BIG_ENDIAN));
        MATCHER_TYPES.put("bedate", new MagicMatcherType("bedate", 4, ByteOrder.BIG_ENDIAN));
        MATCHER_TYPES.put("leshort", new MagicMatcherType("leshort", 2, ByteOrder.LITTLE_ENDIAN));
        MATCHER_TYPES.put("lelong", new MagicMatcherType("lelong", 4, ByteOrder.LITTLE_ENDIAN));
        MATCHER_TYPES.put("ledate", null);
        MATCHER_TYPES.put("leldate", null);
    }

    protected static interface ByteComparator {
        public boolean isValid(byte[] var1, byte[] var2);
    }

    protected static class MagicMatcherType {
        String type;
        int bytes;
        ByteOrder byteOrder;

        public MagicMatcherType(String type, int bytes, ByteOrder byteOrder) {
            this.type = type;
            this.bytes = bytes;
            this.byteOrder = byteOrder;
        }

        public boolean isNumeric() {
            return !this.type.equals("string");
        }

        public String toString() {
            return this.type;
        }
    }
}

