/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.UniformTypeIdentiferContainerTypeAdaptor;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.DescriptionDocumentUtilities;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import com.apple.jingle.leghorn.fileformat.impl.types.PureJavaQuicktimeDescriberVerifier;
import com.apple.jingle.leghorn.subtitle.VTTDocument;
import com.apple.jingle.leghorn.subtitle.VTTDocumentParseException;
import com.apple.jingle.locale.BCP47TagMediator;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.LocaleCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VTTDocumentDescriber
extends SeekableDataInputContainerDescriberVerifier {
    private String schemaName;

    @Override
    public String getToolName() {
        return "FoghornLeghorn VTT Parser";
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            this.describe(sdi, type);
        }
        catch (DescriptionException e) {
            ValidationError error = null;
            if (e.getError() != null) {
                error = new ValidationError(e.getMessage());
            }
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        try {
            VTTDocument vttDocument = new VTTDocument().createVTTDocument(sdi);
            String rootNodeName = "vtt_description";
            Document document = DescriptionDocumentUtilities.constructBasicDescription(rootNodeName, sdi.length(), Configuration.getVersion());
            DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "headerMessage", vttDocument.headerMessage());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "firstSampleTime", vttDocument.firstSampleTime());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "lastSampleTime", vttDocument.lastSampleTime());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "numberOfSamples", vttDocument.numberOfSamples());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "numberOfEmptySamples", vttDocument.numberOfEmptySamples());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "containsRuby", vttDocument.hasRuby());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "containsVerticals", vttDocument.hasVerticals());
            document = VTTDocumentDescriber.addSampleDataTextStats(vttDocument.getSampleTextLineCount(), rootNodeName, document);
            document = VTTDocumentDescriber.addSamplePositionCount(vttDocument, rootNodeName, document);
            document = VTTDocumentDescriber.addStylesInformation(vttDocument, rootNodeName, document);
            document = VTTDocumentDescriber.addFeaturesInformation(vttDocument, rootNodeName, document);
            return new SingleStreamContainerDescription(document, "WebVTT Subtitles", (LocaleCode)BCP47TagMediator.createBCP47Tag((String)"en"), type);
        }
        catch (VTTDocumentParseException ex) {
            throw new DescriptionException(ex);
        }
        catch (BCP47TagParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ContainerDescription<Node> fromDocument(VTTDocument vttDocument, long length, ContainerType type) throws IOException, DescriptionException {
        try {
            String rootNodeName = "vtt_description";
            Document document = DescriptionDocumentUtilities.constructBasicDescription(rootNodeName, length, Configuration.getVersion());
            DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "headerMessage", vttDocument.headerMessage());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "firstSampleTime", vttDocument.firstSampleTime());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "lastSampleTime", vttDocument.lastSampleTime());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "numberOfSamples", vttDocument.numberOfSamples());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "numberOfEmptySamples", vttDocument.numberOfEmptySamples());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "containsRuby", vttDocument.hasRuby());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "containsVerticals", vttDocument.hasVerticals());
            document = VTTDocumentDescriber.addSampleDataTextStats(vttDocument.getSampleTextLineCount(), rootNodeName, document);
            document = VTTDocumentDescriber.addSamplePositionCount(vttDocument, rootNodeName, document);
            return new SingleStreamContainerDescription(document, "WebVTT Subtitles", (LocaleCode)BCP47TagMediator.createBCP47Tag((String)"en"), type);
        }
        catch (BCP47TagParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Document addSamplePositionCount(@Nonnull VTTDocument vttDocument, @Nonnull String rootNodeName, @Nonnull Document document) {
        String samplePositionCount = "samplePositionCount";
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, samplePositionCount, "");
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, samplePositionCount, "topSamplesCount", vttDocument.getTopSamplesCount());
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, samplePositionCount, "bottomSamplesCount", vttDocument.getBottomSamplesCount());
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, samplePositionCount, "leftSamplesCount", vttDocument.getLeftSamplesCount());
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, samplePositionCount, "rightSamplesCount", vttDocument.getRightSamplesCount());
        return document;
    }

    private static Document addStylesInformation(@Nonnull VTTDocument vttDocument, @Nonnull String rootNodeName, @Nonnull Document document) {
        Map<String, String> styles = vttDocument.getStyles();
        if (styles.size() == 0) {
            return document;
        }
        String stylesElementName = "styles";
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, stylesElementName, "");
        for (Map.Entry<String, String> e : styles.entrySet()) {
            document = DescriptionDocumentUtilities.addDescriptionWithAttribute(document, stylesElementName, "style", e.getValue().trim(), Collections.singletonMap("id", e.getKey()));
        }
        return document;
    }

    private static Document addFeaturesInformation(@Nonnull VTTDocument vttDocument, @Nonnull String rootNodeName, @Nonnull Document document) {
        Set<String> features = vttDocument.computeFeatureTags();
        if (features.size() == 0) {
            return document;
        }
        String featuresElementName = "features";
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, featuresElementName, "");
        for (String feat : features) {
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, featuresElementName, "feature", feat);
        }
        return document;
    }

    @Nonnull
    private static Document addSampleDataTextStats(@Nonnull long[] sampleTextLineCount, @Nonnull String rootNodeName, @Nonnull Document document) {
        String sampleDataTextStatsNodeName = "sampleDataTextStats";
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, sampleDataTextStatsNodeName, "");
        for (int i = 0; i < 4; ++i) {
            HashMap attributes = Maps.newHashMap();
            attributes.put("lines", Integer.toString(i + 1));
            document = DescriptionDocumentUtilities.addDescriptionWithAttribute(document, sampleDataTextStatsNodeName, "lineCount", Long.toString(sampleTextLineCount[i]), attributes);
        }
        return document;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public static void main(String[] args) throws Exception {
        UniformTypeIdentifier uti = UniformTypeIdentifier.COM_APPLE_QUICKTIME_WVTT;
        UniformTypeIdentiferContainerTypeAdaptor containerType = new UniformTypeIdentiferContainerTypeAdaptor(uti);
        VTTDocumentDescriber describer = new VTTDocumentDescriber();
        URI uri = ContainerContainerDescriberRunner.uriForString(args[0], true);
        SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)uri);
        if (!describer.verifyContainerType(sdi, (ContainerType)containerType, null)) {
            System.out.println("verifyContainerType failed");
        } else {
            ContainerContainerDescriberRunner.main(new PureJavaQuicktimeDescriberVerifier(), uti, args);
        }
    }
}

