/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.DescriptionDocumentUtilities;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import com.apple.jingle.leghorn.texml.xml.ColorCountStatistic;
import com.apple.jingle.leghorn.texml.xml.ColorCountStatistics;
import com.apple.jingle.leghorn.texml.xml.SampleBox;
import com.apple.jingle.leghorn.texml.xml.SampleCountStatistics;
import com.apple.jingle.leghorn.texml.xml.SampleTextBox;
import com.apple.jingle.leghorn.texml.xml.SampleTime;
import com.apple.jingle.leghorn.texml.xml.TexmlDescriptionDocument;
import com.apple.jingle.leghorn.texml.xml.TextLineStatistic;
import com.apple.jingle.leghorn.texml.xml.TextLineStatistics;
import com.apple.jingle.leghorn.util.XmlBeansHelper;
import com.apple.jingle.locale.BCP47TagMediator;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.LocaleCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableInputStream;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TimedTextDocumentDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    private static final String WHITE_COLOR_STYLE = "{color: 100%, 100%, 100%, 100%}";

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            this.describe(sdi, type);
        }
        catch (DescriptionException e) {
            ValidationError error = null;
            if (e.getError() != null) {
                error = new ValidationError(e.getMessage());
            }
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        String language;
        TexmlDescriptionDocument descDocument = TexmlDescriptionDocument.Factory.newInstance();
        TexmlDescriptionDocument.TexmlDescription desc = descDocument.addNewTexmlDescription();
        desc.setFileSize(new BigInteger(Long.toString(sdi.length())));
        this.writeBasicDesciptionAttributes(desc.newCursor(), desc.addNewDescriber());
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((InputStream)new SeekableInputStream(sdi), XmlBeansHelper.getXmlOptionsWithDisabledXXE());
            String texmlLang = XmlBeansHelper.toXmlString(xmlObject, "//subtitleTrack/@language");
            language = texmlLang.isEmpty() ? "und" : texmlLang;
            desc.setLanguage(language);
            BigInteger timeScale = BigInteger.valueOf(Long.valueOf(XmlBeansHelper.toXmlString(xmlObject, "//subtitleTrack/@timeScale")));
            desc.setTimeScale(timeScale);
            TimedTextBox mainTimedTextBox = new TimedTextBox(XmlBeansHelper.toXmlObject(xmlObject, "//subtitleTrack"));
            desc.setTrackTextBox(this.getSampleBox(mainTimedTextBox));
            long totalDuration = 0L;
            long sampleCount = 0L;
            long lastSampleTime = 0L;
            long topSampleCount = 0L;
            long bottomSampleCount = 0L;
            long whiteColorStyleCount = 0L;
            long otherColorStyleCount = 0L;
            boolean firstSampleTimeFound = false;
            boolean obey = false;
            SampleTextLineCounter lineCounter = new SampleTextLineCounter();
            for (XmlObject sampleNode : XmlBeansHelper.toXmlObjects(xmlObject, "//subtitleTrack/sample")) {
                if (XmlBeansHelper.toXmlBoolean(sampleNode, "@forced")) {
                    desc.setForced(true);
                }
                String sampleDataText = XmlBeansHelper.toXmlString(sampleNode, "sampleData/text");
                lineCounter.count(sampleDataText);
                if (!this.isEmptySample(sampleDataText)) {
                    XmlObject descriptionNode = XmlBeansHelper.toXmlObject(sampleNode, "description");
                    TimedTextSampleDescription timedTextSampleDescription = new TimedTextSampleDescription(descriptionNode, mainTimedTextBox);
                    if (!obey && timedTextSampleDescription.isObey()) {
                        obey = true;
                    }
                    if (timedTextSampleDescription.getVerticalJustification() == VerticalJustification.TOP) {
                        ++topSampleCount;
                    } else if (timedTextSampleDescription.getVerticalJustification() == VerticalJustification.BOTTOM) {
                        ++bottomSampleCount;
                    }
                    if (timedTextSampleDescription.getStyle().contains(WHITE_COLOR_STYLE)) {
                        ++whiteColorStyleCount;
                    } else {
                        ++otherColorStyleCount;
                    }
                    if (!firstSampleTimeFound) {
                        desc.setFirstSampleTime(this.getSampleTime(timeScale, totalDuration));
                        firstSampleTimeFound = true;
                        TimedTextBox timedTextBox = new TimedTextBox(XmlBeansHelper.toXmlObject(descriptionNode, "defaultTextBox"));
                        desc.setTextBox(this.getSampleTextBox(timedTextBox));
                    }
                    ++sampleCount;
                    lastSampleTime = totalDuration;
                }
                totalDuration += (long)XmlBeansHelper.toXmlInteger(sampleNode, "@duration");
            }
            desc.setSampleDataTextStats(lineCounter.getTextLineStatistics());
            desc.setColorCountStats(this.getColorCountStatistics(whiteColorStyleCount, otherColorStyleCount));
            desc.setSampleCountStats(this.getSampleCountStatistics(topSampleCount, bottomSampleCount, obey));
            desc.setNumberOfSamples(BigInteger.valueOf(sampleCount));
            desc.setLastSampleTime(this.getSampleTime(timeScale, lastSampleTime));
            desc.setDuration(this.getSampleTime(timeScale, totalDuration));
        }
        catch (NumberFormatException e) {
            return this.fallbackDescribe(sdi, type);
        }
        catch (XmlException e) {
            return this.fallbackDescribe(sdi, type);
        }
        catch (Exception e) {
            throw new DescriptionException(e);
        }
        try {
            return new SingleStreamContainerDescription(descDocument.getDomNode(), "Subtitle", (LocaleCode)BCP47TagMediator.createBCP47Tag((String)language), type);
        }
        catch (BCP47TagParseException re) {
            throw new DescriptionException(re);
        }
    }

    private ContainerDescription<Node> fallbackDescribe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        String rootNodeName = "texml_description";
        Document document = DescriptionDocumentUtilities.constructBasicDescription(rootNodeName, 0L, Configuration.getVersion());
        return new SingleStreamContainerDescription(document, "Subtitle", null, type);
    }

    @Nonnull
    private ColorCountStatistics getColorCountStatistics(long whiteColorStyleCount, long otherColorStyleCount) {
        ColorCountStatistics colorCountStatistics = ColorCountStatistics.Factory.newInstance();
        ColorCountStatistic whiteColorCount = colorCountStatistics.addNewColorCount();
        whiteColorCount.setColor("white");
        whiteColorCount.setBigIntegerValue(BigInteger.valueOf(whiteColorStyleCount));
        ColorCountStatistic otherColorCount = colorCountStatistics.addNewColorCount();
        otherColorCount.setColor("other");
        otherColorCount.setBigIntegerValue(BigInteger.valueOf(otherColorStyleCount));
        return colorCountStatistics;
    }

    private boolean isEmptySample(@Nonnull String sampleDataText) {
        return sampleDataText.isEmpty();
    }

    @Nonnull
    private SampleCountStatistics getSampleCountStatistics(long topSampleCount, long bottomSampleCount, boolean obey) {
        SampleCountStatistics sampleCountStatistics = SampleCountStatistics.Factory.newInstance();
        sampleCountStatistics.setObey(obey);
        sampleCountStatistics.setTopSamples(BigInteger.valueOf(topSampleCount));
        sampleCountStatistics.setBottomSamples(BigInteger.valueOf(bottomSampleCount));
        return sampleCountStatistics;
    }

    @Nonnull
    private SampleTime getSampleTime(BigInteger timeScale, long sampleTime) {
        SampleTime samplesDuration = SampleTime.Factory.newInstance();
        samplesDuration.setTimeScale(timeScale);
        samplesDuration.setBigIntegerValue(BigInteger.valueOf(sampleTime));
        return samplesDuration;
    }

    @Nonnull
    private SampleBox getSampleBox(@Nonnull TimedTextBox timedTextBox) {
        SampleBox trackTextBox = SampleBox.Factory.newInstance();
        trackTextBox.setWidth(BigInteger.valueOf(timedTextBox.getWidth()));
        trackTextBox.setHeight(BigInteger.valueOf(timedTextBox.getHeight()));
        return trackTextBox;
    }

    @Nonnull
    private SampleTextBox getSampleTextBox(@Nonnull TimedTextBox timedTextBox) {
        SampleTextBox trackTextBox = SampleTextBox.Factory.newInstance();
        trackTextBox.setX(BigInteger.valueOf(timedTextBox.getX()));
        trackTextBox.setY(BigInteger.valueOf(timedTextBox.getY()));
        trackTextBox.setWidth(BigInteger.valueOf(timedTextBox.getWidth()));
        trackTextBox.setHeight(BigInteger.valueOf(timedTextBox.getHeight()));
        return trackTextBox;
    }

    public String getSchemaName() {
        return null;
    }

    public void setSchemaName(String name) {
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn 3GPP TeXML Timed Text Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    private class SampleTextLineCounter {
        private static final int LINE_COUNT_LIMIT = 4;
        private final long[] sampleTextLineCount = new long[4];

        private SampleTextLineCounter() {
        }

        public void count(@Nonnull String text) {
            int lines = this.countLine(text);
            if (lines >= 4) {
                this.sampleTextLineCount[3] = this.sampleTextLineCount[3] + 1L;
            } else {
                int n = lines - 1;
                this.sampleTextLineCount[n] = this.sampleTextLineCount[n] + 1L;
            }
        }

        @Nonnull
        private TextLineStatistics getTextLineStatistics() {
            TextLineStatistics textLineStatistics = TextLineStatistics.Factory.newInstance();
            for (int i = 0; i < 4; ++i) {
                if (this.sampleTextLineCount[i] <= 0L) continue;
                TextLineStatistic lineCount = textLineStatistics.addNewLineCount();
                lineCount.setLines(BigInteger.valueOf(i + 1));
                lineCount.setBigIntegerValue(BigInteger.valueOf(this.sampleTextLineCount[i]));
            }
            return textLineStatistics;
        }

        private int countLine(String text) {
            return text.split(System.getProperty("line.separator")).length;
        }
    }

    private class TimedTextSampleDescription {
        private final List<String> displayFlags;
        private final boolean obey;
        private final TimedTextBox timedTextBox;
        private final String style;
        private final VerticalJustification verticalJustification;

        protected TimedTextSampleDescription(@Nonnull XmlObject descriptionNode, TimedTextBox mainTextBox) throws DescriptionException {
            String displayFlags = XmlBeansHelper.toXmlString(descriptionNode, "@displayFlags");
            if (!displayFlags.isEmpty()) {
                this.displayFlags = Arrays.asList(displayFlags.trim().split("\\s*,\\s*"));
                this.obey = this.displayFlags.contains("obey");
            } else {
                this.displayFlags = Lists.newArrayList();
                this.obey = false;
            }
            XmlObject defaultTextBox = XmlBeansHelper.toXmlObject(descriptionNode, "defaultTextBox");
            if (defaultTextBox == null) {
                throw new DescriptionException("defaultTextBox tag missing in the TeXML file for one of the sample");
            }
            this.timedTextBox = new TimedTextBox(defaultTextBox);
            this.style = XmlBeansHelper.toXmlString(descriptionNode, "sharedStyles/style");
            this.verticalJustification = this.obey && mainTextBox.height / 2 > this.timedTextBox.y + this.timedTextBox.height ? VerticalJustification.TOP : VerticalJustification.BOTTOM;
        }

        public boolean isObey() {
            return this.obey;
        }

        public List<String> getDisplayFlags() {
            return this.displayFlags;
        }

        public String getStyle() {
            return this.style;
        }

        public TimedTextBox getTimedTextBox() {
            return this.timedTextBox;
        }

        public VerticalJustification getVerticalJustification() {
            return this.verticalJustification;
        }
    }

    private class TimedTextBox {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final boolean isMainTextBox;

        protected TimedTextBox(XmlObject xmlObject) {
            this.x = XmlBeansHelper.toXmlInteger(xmlObject, "@x");
            this.y = XmlBeansHelper.toXmlInteger(xmlObject, "@y");
            int width = XmlBeansHelper.toXmlInteger(xmlObject, "@width");
            int height = XmlBeansHelper.toXmlInteger(xmlObject, "@height");
            if (width == 0 && height == 0) {
                this.isMainTextBox = true;
                width = XmlBeansHelper.toXmlInteger(xmlObject, "@trackWidth");
                height = XmlBeansHelper.toXmlInteger(xmlObject, "@trackHeight");
            } else {
                this.isMainTextBox = false;
            }
            this.width = width;
            this.height = height;
        }

        public int getY() {
            return this.y;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isMainTextBox() {
            return this.isMainTextBox;
        }

        public int getWidth() {
            return this.width;
        }

        public int getX() {
            return this.x;
        }
    }

    private static enum VerticalJustification {
        TOP,
        BOTTOM,
        INVALID;

    }
}

