/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.subtitle.SubtitleSummary;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDescriptionDocument;
import com.apple.jingle.locale.BCP47TagMediator;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.LocaleCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.xmlbeans.XmlObject;
import org.w3.ns.ttml.TtDocument;
import org.w3.ns.ttml.TtEltype;
import org.w3c.dom.Node;

public class SubtitleDocumentDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        SubtitleSummary summary = new SubtitleSummary(sdi);
        SubtitleDescriptionDocument.SubtitleDescription desc = summary.getDescription().getSubtitleDescription();
        desc.setFileSize(new BigInteger(Long.toString(sdi.length())));
        this.writeBasicDesciptionAttributes(desc.newCursor(), desc.addNewDescriber());
        String language = "und";
        if (summary.getDocument() != null) {
            TtDocument ttDoc = summary.getDocument();
            TtEltype tt = ttDoc.getTt();
            language = tt.getLang();
            desc.setLanguage(language);
            if (tt.isSetProfile()) {
                desc.setProfile(tt.getProfile());
            }
            if (tt.isSetTimeBase()) {
                desc.setTimeBase(tt.getTimeBase().toString());
            }
            if (tt.isSetFrameRate()) {
                desc.setFrameRate(tt.getFrameRate());
            }
            if (tt.isSetFrameRateMultiplier()) {
                desc.setFrameRateMultiplier(tt.getFrameRateMultiplier());
            }
            if (tt.isSetDropMode()) {
                desc.setDropMode(tt.getDropMode().toString());
            }
            if (tt.isSetMarkerMode()) {
                desc.setMarkerMode(tt.getMarkerMode().toString());
            }
            desc.setUnicodeStatistics((XmlObject)summary.computeUnicodeStatistics());
            desc.setLongestLineLength(BigInteger.valueOf(summary.getLongestLineLength()));
        }
        try {
            return new SingleStreamContainerDescription(summary.getDescription().getDomNode(), "Subtitle", (LocaleCode)BCP47TagMediator.createBCP47Tag((String)language), type);
        }
        catch (BCP47TagParseException re) {
            throw new DescriptionException(re);
        }
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            SubtitleSummary summary = new SubtitleSummary(sdi);
            summary.getDescription().getSubtitleDescription();
            if (null != listener) {
                summary.getValidationContext().notifyListener(listener);
            }
            return !summary.getValidationContext().hasValidations(ValidationLevel.ERROR);
        }
        catch (RuntimeException e) {
            ValidationError error = new ValidationError(e.getMessage());
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn Subtitle Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    public static void main(String[] args) throws Exception {
        ContainerContainerDescriberRunner.main(new SubtitleDocumentDescriberVerifier(), UniformTypeIdentifier.COM_APPLE_ITUNES_TIMED_TEXT, args);
    }
}

