/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import com.apple.jingle.leghorn.media.beans.NotificationList;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.scc.SCCDocument;
import com.apple.jingle.leghorn.scc.xml.SccDescriptionDocument;
import com.apple.jingle.locale.BCP47TagMediator;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.LocaleCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.math.BigInteger;
import org.w3c.dom.Node;

public class SCCDocumentDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    public String getSchemaName() {
        return "SCCDescription.xsd";
    }

    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        try {
            NotificationList notificationList;
            SCCDocument sccDocument = SCCDocument.createSCCDocument(sdi);
            SccDescriptionDocument.SccDescription description = SccDescriptionDocument.Factory.newInstance().addNewSccDescription();
            this.writeBasicDesciptionAttributes(description.newCursor(), description.addNewDescriber());
            description.setFileSize(new BigInteger(Long.toString(sdi.length())));
            description.setNumberOfSamples(new BigInteger(Integer.toString(sccDocument.getNumberOfSamples())));
            description.setMaximumFrameIndex(new BigInteger(Integer.toString(sccDocument.getMaximumFrameIndex())));
            description.setContainsDropFrame(sccDocument.hasDropFrame());
            description.setContainsNonDropFrame(sccDocument.hasNonDropFrame());
            description.setEndsWithNewline(sccDocument.endsWithNewline());
            description.setLongestLineLength(BigInteger.valueOf(sccDocument.getLongestLineLength()));
            if (sccDocument.getFirstTimeCode() != null) {
                description.setFirstTimeCode(sccDocument.getFirstTimeCode().toString());
            }
            if (sccDocument.getLastTimeCode() != null) {
                description.setLastTimeCode(sccDocument.getLastTimeCode().toString());
            }
            if ((notificationList = description.getNotifications()) == null) {
                notificationList = description.addNewNotifications();
            }
            sccDocument.getValidationContext().populateAlertList(notificationList, ValidationLevel.INFO);
            return new SingleStreamContainerDescription(description.getDomNode(), "Closed Captions", (LocaleCode)BCP47TagMediator.createBCP47Tag((String)"en"), type);
        }
        catch (BCP47TagParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            SCCDocument sccDocument = SCCDocument.createSCCDocument(sdi);
            if (null != listener) {
                sccDocument.getValidationContext().notifyListener(listener);
            }
            return !sccDocument.getValidationContext().hasValidationErrors();
        }
        catch (RuntimeException e) {
            ValidationError error = new ValidationError(e.getMessage());
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn SCC Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }
}

