/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.FormatDescription;
import com.apple.jingle.leghorn.fileformat.UniformTypeIdentiferContainerTypeAdaptor;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.FormatDescriptionImpl;
import com.apple.jingle.leghorn.fileformat.impl.FormatTypeImpl;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SlightlyMoreAdvancedContainerDescription;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.MediaDescriptionGenerator;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.quicktime.QuickTimeParser;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.locale.BCP47Tag;
import com.apple.jingle.locale.BCP47TagMediator;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.LocaleCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import noNamespace.Language;
import noNamespace.MovieDocument;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PureJavaQuicktimeDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        QuickTimeValidationContext ctx = new QuickTimeValidationContext(sdi.getFileName(), this.getToolName(), this.getToolVersion());
        return this.describe(ctx, sdi, type);
    }

    public ContainerDescription<Node> describe(QuickTimeValidationContext ctx, SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        QuickTimeFile qtf = new QuickTimeParser(QuickTimeFile.Type.QuickTime).parseFile((LeghornValidationContext)ctx, sdi);
        try {
            MovieDocument o = MediaDescriptionGenerator.generateDescription(ctx, qtf);
            return PureJavaQuicktimeDescriberVerifier.setupContainerDescription(type, o);
        }
        catch (RuntimeException | ParserConfigurationException | SAXException e) {
            throw new DescriptionException(e);
        }
    }

    public static ContainerDescription<Node> setupContainerDescription(ContainerType type, MovieDocument o) throws IOException, ParserConfigurationException, SAXException {
        StringWriter sw = new StringWriter();
        o.save((Writer)sw);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder db = dbFactory.newDocumentBuilder();
        String documentEncoding = "UTF-8";
        if (o.documentProperties().getEncoding() != null) {
            documentEncoding = o.documentProperties().getEncoding();
        }
        Document descriptionXml = db.parse(new ByteArrayInputStream(sw.getBuffer().toString().getBytes(documentEncoding)));
        return PureJavaQuicktimeDescriberVerifier.containerDescriptionForXml(descriptionXml, type);
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            QuickTimeValidationContext ctx = new QuickTimeValidationContext(sdi.getFileName(), this.getToolName(), this.getToolVersion());
            this.describe(ctx, sdi, type);
            if (null != listener) {
                ctx.notifyListener(listener);
            }
            return !ctx.hasValidations(MediaValidationCode.FILE_APPEARS_CORRUPT, MediaValidationCode.MOV_CONTAINER_INCOMPATIBLE);
        }
        catch (DescriptionException e) {
            ValidationError error = e.getError() == null ? new ValidationError(e.getMessage(), MediaValidationCode.FILE_APPEARS_CORRUPT) : e.getError();
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn Quicktime Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    private static ContainerDescription<Node> containerDescriptionForXml(Document document, ContainerType type) {
        SlightlyMoreAdvancedContainerDescription containerDescription;
        try {
            containerDescription = new SlightlyMoreAdvancedContainerDescription(document, type, "/movie/tracks/*", "./track_id/text()", new SlightlyMoreAdvancedContainerDescription.FormatDescriptionGenerator(){

                @Override
                public FormatDescription<Node> getFormatDescriptionFromStream(final XmlObject streamNode, XmlObject descriptionDocument) {
                    BCP47Tag language;
                    final FormatTypeImpl formatType = new FormatTypeImpl(((XmlString)streamNode.selectPath("name(.)")[0]).getStringValue());
                    XmlObject[] languageNodes = streamNode.selectPath("./language");
                    if (languageNodes.length == 0) {
                        language = null;
                    } else {
                        try {
                            language = BCP47TagMediator.createBCP47Tag((String)((Language)languageNodes[0]).getStringValue());
                        }
                        catch (BCP47TagParseException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return new FormatDescriptionImpl(streamNode.getDomNode(), formatType, (LocaleCode)language){

                        @Override
                        public String getPresentableDescription() {
                            String descStr = formatType.getName().equals("video") ? String.format("%s (%sx%s), %sFPS", PureJavaQuicktimeDescriberVerifier.getXpathString(streamNode, "./codec/@name"), PureJavaQuicktimeDescriberVerifier.getXpathString(streamNode, "./track_dimensions/width"), PureJavaQuicktimeDescriberVerifier.getXpathString(streamNode, "./track_dimensions/height"), PureJavaQuicktimeDescriberVerifier.getXpathString(streamNode, "./frame_rate")) : (formatType.getName().equals("sound") ? String.format("%s, %s-bit, %sKhz, %s", PureJavaQuicktimeDescriberVerifier.getXpathString(streamNode, "./codec/@name"), PureJavaQuicktimeDescriberVerifier.getXpathString(streamNode, "./bit_depth"), PureJavaQuicktimeDescriberVerifier.getXpathString(streamNode, "./sample_rate"), PureJavaQuicktimeDescriberVerifier.getChannelString(streamNode)) : "");
                            return descStr;
                        }
                    };
                }
            });
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
        return containerDescription;
    }

    private static String getChannelString(XmlObject node) {
        String result = "";
        try {
            int chanCnt = 0;
            XmlObject[] selectedNodes = node.selectPath("./channel_layout/channel");
            if (selectedNodes != null) {
                chanCnt = selectedNodes.length;
            }
            result = chanCnt == 1 ? PureJavaQuicktimeDescriberVerifier.getXpathString(node, "./channel_layout/channel") : PureJavaQuicktimeDescriberVerifier.getXpathString(node, "./channel_layout/@name");
        }
        catch (RuntimeException e) {
            result = e.toString();
        }
        return result;
    }

    private static String getXpathString(XmlObject node, String xpath) {
        String result = "";
        try {
            XmlObject[] selectedNodes = node.selectPath(xpath);
            if (selectedNodes != null && selectedNodes.length > 0) {
                XmlCursor cur = selectedNodes[0].newCursor();
                result = cur.getTextValue();
            }
        }
        catch (RuntimeException e) {
            result = e.toString();
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        UniformTypeIdentifier uti = UniformTypeIdentifier.COM_APPLE_QUICKTIME_MOVIE;
        UniformTypeIdentiferContainerTypeAdaptor containerType = new UniformTypeIdentiferContainerTypeAdaptor(uti);
        PureJavaQuicktimeDescriberVerifier describer = new PureJavaQuicktimeDescriberVerifier();
        URI uri = ContainerContainerDescriberRunner.uriForString(args[0], true);
        SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)uri);
        if (!describer.verifyContainerType(sdi, (ContainerType)containerType, null)) {
            System.out.println("verifyContainerType failed");
        } else {
            ContainerContainerDescriberRunner.main(new PureJavaQuicktimeDescriberVerifier(), uti, args);
        }
    }
}

