/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.UniformTypeIdentiferContainerTypeAdaptor;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.types.PureJavaQuicktimeDescriberVerifier;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.MPEG4Parser;
import com.apple.jingle.leghorn.quicktime.MediaDescriptionGenerator;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import noNamespace.MovieDocument;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PureJavaMPEG4DescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        QuickTimeValidationContext ctx = new QuickTimeValidationContext(sdi.getFileName(), this.getToolName(), this.getToolVersion());
        return this.describe(ctx, sdi, type);
    }

    public ContainerDescription<Node> describe(LeghornValidationContext ctx, SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        QuickTimeFile qtf = new MPEG4Parser(QuickTimeFile.Type.MPEG4).parseFile(ctx, sdi);
        try {
            MovieDocument o = MediaDescriptionGenerator.generateDescription(ctx, qtf);
            return PureJavaQuicktimeDescriberVerifier.setupContainerDescription(type, o);
        }
        catch (ParserConfigurationException e) {
            throw new DescriptionException(e);
        }
        catch (SAXException e) {
            throw new DescriptionException(e);
        }
        catch (RuntimeException re) {
            throw new DescriptionException(re);
        }
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            QuickTimeValidationContext ctx = new QuickTimeValidationContext(sdi.getFileName(), this.getToolName(), this.getToolVersion());
            this.describe(ctx, sdi, type);
            if (null != listener) {
                ctx.notifyListener(listener);
            }
            return !ctx.hasValidations(MediaValidationCode.FILE_APPEARS_CORRUPT, MediaValidationCode.MOV_CONTAINER_INCOMPATIBLE);
        }
        catch (DescriptionException e) {
            ValidationError error = e.getError() == null ? new ValidationError(e.getMessage(), MediaValidationCode.FILE_APPEARS_CORRUPT) : e.getError();
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn MPEG-4 Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    public static void main(String[] args) throws Exception {
        UniformTypeIdentifier uti = UniformTypeIdentifier.PUBLIC_MPEG_4_VIDEO;
        UniformTypeIdentiferContainerTypeAdaptor containerType = new UniformTypeIdentiferContainerTypeAdaptor(uti);
        PureJavaMPEG4DescriberVerifier describer = new PureJavaMPEG4DescriberVerifier();
        URI uri = ContainerContainerDescriberRunner.uriForString(args[0], true);
        SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)uri);
        if (!describer.verifyContainerType(sdi, (ContainerType)containerType, null)) {
            System.out.println("verifyContainerType failed");
        } else {
            ContainerContainerDescriberRunner.main(new PureJavaMPEG4DescriberVerifier(), uti, args);
        }
    }
}

