/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.DescriptionDocumentUtilities;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import com.apple.jingle.locale.BCP47TagMediator;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.LocaleCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PropertyListDescriber
extends SeekableDataInputContainerDescriberVerifier {
    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        try {
            String rootNodeName = "plist_description";
            Document document = DescriptionDocumentUtilities.constructBasicDescription(rootNodeName, 0L, Configuration.getVersion());
            return new SingleStreamContainerDescription(document, "Property List", (LocaleCode)BCP47TagMediator.createBCP47Tag((String)"en"), type);
        }
        catch (BCP47TagParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            this.describe(sdi, type);
        }
        catch (DescriptionException e) {
            ValidationError error = null;
            if (e.getError() != null) {
                error = new ValidationError(e.getMessage());
            }
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn property list Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }
}

