/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.mpeg2.MPEG2DescriptionGenerator;
import com.apple.jingle.leghorn.mpeg2.ProgramStream;
import com.apple.jingle.leghorn.mpeg2.ProgramStreamValidationContext;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.IOException;
import org.w3c.dom.Node;

public class MPEG2ProgramStreamDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        ProgramStreamValidationContext ctx = new ProgramStreamValidationContext(sdi.getFileName(), this.getToolName(), this.getToolVersion());
        return this.describe(ctx, sdi, type);
    }

    public ContainerDescription<Node> describe(LeghornValidationContext ctx, SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        ProgramStream programStream = new ProgramStream();
        programStream.parse(ctx, sdi);
        return MPEG2DescriptionGenerator.generateDescription(ctx, programStream);
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            ProgramStreamValidationContext ctx = new ProgramStreamValidationContext(sdi.getFileName());
            this.describe(ctx, sdi, type);
            if (null != listener) {
                ctx.notifyListener(listener);
            }
            return !ctx.hasValidations(MediaValidationCode.FILE_APPEARS_CORRUPT, MediaValidationCode.MOV_CONTAINER_INCOMPATIBLE);
        }
        catch (DescriptionException e) {
            ValidationError error = e.getError() == null ? new ValidationError(e.getMessage(), MediaValidationCode.FILE_APPEARS_CORRUPT) : e.getError();
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn MPEG-2 Program Stream Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    public static void main(String[] args) throws Exception {
        ContainerContainerDescriberRunner.main(new MPEG2ProgramStreamDescriberVerifier(), UniformTypeIdentifier.PUBLIC_MPEG_2_VIDEO, args);
    }
}

