/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.its.asset.lsr.ImageSet;
import com.apple.its.asset.lsr.ImageStackLayer;
import com.apple.its.asset.lsr.LSRException;
import com.apple.its.asset.lsr.LSRFile;
import com.apple.its.asset.lsr.io.ImageBuffer;
import com.apple.its.asset.lsr.json.Contents;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.exceptions.UnknownTypeException;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SimpleContainerDescription;
import com.apple.jingle.leghorn.fileformat.impl.ValidationsCollector;
import com.apple.jingle.leghorn.fileformat.impl.VerifierBuilder;
import com.apple.jingle.leghorn.image.ImageDescriptionGenerator;
import com.apple.jingle.leghorn.image.beans.ImageEntry;
import com.apple.jingle.leghorn.image.beans.ImageLayer;
import com.apple.jingle.leghorn.image.beans.ImageSet;
import com.apple.jingle.leghorn.image.beans.Json;
import com.apple.jingle.leghorn.image.beans.LsrDocument;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import org.w3c.dom.Node;

public class LayeredImageDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    public static final String CDATA_PREFIX = "<![CDATA[";
    public static final String CDATA_SUFFIX = "]]>";
    public static final String uti = "public.lsr";
    private Verifier verifier;
    private LSRFile lsrFile;

    @Override
    public String getToolName() {
        return "FoghornLeghorn LSR Describer";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws DescriptionException {
        ValidationsCollector listener = new ValidationsCollector();
        SimpleContainerDescription containerDescription = new SimpleContainerDescription();
        try {
            if (this.verifyContainerType(sdi, type, (ValidationListener)listener)) {
                LsrDocument lsrDoc = LsrDocument.Factory.newInstance();
                LsrDocument.Lsr lsrElement = lsrDoc.addNewLsr();
                lsrElement.setFilename(sdi.getFileName());
                Contents jsonContents = this.lsrFile.createJson();
                Json topLevelJson = lsrElement.addNewJson();
                topLevelJson.setStringValue(this.jsonText(jsonContents.toString()));
                for (ImageStackLayer layer : this.lsrFile) {
                    this.describe(lsrElement, layer);
                }
                containerDescription.setDescriptionDocument(lsrDoc.getDomNode());
                return containerDescription;
            }
            throw new DescriptionException(this.collectErrors(listener));
        }
        catch (DescriptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DescriptionException(e);
        }
    }

    private void describe(LsrDocument.Lsr lsrElement, ImageStackLayer layer) throws UnknownTypeException, VerifierBuilder.UnableToBuildVerifierException, IOException {
        ImageLayer layerElement = lsrElement.addNewImageLayer();
        layerElement.setFilename(layer.name());
        Json layerJson = layerElement.addNewJson();
        layerJson.setStringValue(this.jsonText(layer.createJSON().toString()));
        ImageSet imageSetElement = layerElement.addNewImageSet();
        String entryJson = layer.getImageSet().getContents().toString();
        for (ImageSet.Entry entry : layer.getImageSet()) {
            this.describe(imageSetElement, entry, entryJson);
        }
    }

    private void describe(ImageSet imageSetElement, ImageSet.Entry entry, String json) throws UnknownTypeException, VerifierBuilder.UnableToBuildVerifierException, IOException {
        ImageEntry imageEntry = imageSetElement.addNewImageEntry();
        imageEntry.addNewJson().setStringValue(this.jsonText(json));
        this.describeSingleEntry(imageEntry, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeSingleEntry(ImageEntry imageEntry, ImageSet.Entry entry) throws UnknownTypeException, VerifierBuilder.UnableToBuildVerifierException, IOException {
        ContainerType type = this.getVerifier().getContainerTypeFactory().getTypeForExtension(FileUtilities.fileExtension((String)entry.filename()));
        byte[] imageBytes = entry.imageBuffer().toBytes();
        sdi.setFileName(entry.filename());
        try (ByteArraySeekableDataInput sdi = new ByteArraySeekableDataInput(imageBytes, (long)imageBytes.length);){
            ImageDescriptionGenerator.generateDescription((SeekableDataInput)sdi, type, imageEntry);
        }
    }

    private String jsonText(String jsonContent) {
        return CDATA_PREFIX + jsonContent + CDATA_SUFFIX;
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        if (!uti.equals(type.getUTITypeName())) {
            listener.error(new ValidationError("Invalid uti for lir file: " + type.getUTITypeName()));
            return false;
        }
        try {
            byte[] imageBytes = new byte[(int)sdi.length()];
            sdi.readFully(imageBytes);
            this.lsrFile = new LSRFile(imageBytes, ImageBuffer.Strategy.heap);
            this.lsrFile.validate();
            return true;
        }
        catch (LSRException e) {
            listener.error(new ValidationError("Invalid layered image: " + sdi.getFileName() + ". " + e.getMessage(), MediaValidationCode.IMG_BAD_DATA));
            return false;
        }
    }

    private String collectErrors(ValidationsCollector collector) {
        StringBuilder builder = new StringBuilder();
        for (ValidationError error : collector.getValidationErrors()) {
            builder.append(error.getUserString()).append("\n");
        }
        return builder.toString();
    }

    private Verifier getVerifier() throws VerifierBuilder.UnableToBuildVerifierException {
        if (this.verifier == null) {
            this.verifier = Verifier.getDefaultVerifier();
        }
        return this.verifier;
    }
}

