/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.UniformTypeIdentiferContainerTypeAdaptor;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationInfo;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.ValidationWarning;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SimpleContainerDescription;
import com.apple.jingle.leghorn.fileformat.impl.ValidationsCollector;
import com.apple.jingle.leghorn.image.ImageDescriptionGenerator;
import com.apple.jingle.leghorn.image.jpeg.JPEGParser;
import com.apple.jingle.leghorn.image.png.PNGParser;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Node;

public class ImageDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    private static final byte[] TIFF_HEADER_INTEL = new byte[]{73, 73, 42, 0};
    private static final byte[] TIFF_HEADER_MOTOROLA = new byte[]{77, 77, 0, 42};
    protected String schemaName;

    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        if (sdi == null) {
            if (type != null) {
                throw new IllegalArgumentException("Expected image file of type " + type.getName() + " was missing");
            }
            throw new IllegalArgumentException("Expected image file was missing");
        }
        SimpleContainerDescription containerDescription = new SimpleContainerDescription();
        ValidationsCollector collector = new ValidationsCollector();
        if (!this.verifyContainerType(sdi, type, (ValidationListener)collector)) {
            String filename = sdi.getFileName();
            String extension = ".itmsp";
            int index = filename.indexOf(".itmsp");
            if (index > 0) {
                filename = filename.substring(index + ".itmsp".length());
            }
            throw new DescriptionException(filename + " does not match type " + type.getName() + " because of these validation issues: ", collector.getValidationErrors().get(0));
        }
        containerDescription.setDescriptionDocument(ImageDescriptionGenerator.generateDescription(sdi, type, (ValidationListener)new ValidationsCollector()).getDomNode());
        return containerDescription;
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            if (listener == null) {
                listener = new ValidationsCollector();
            }
            boolean isVerified = false;
            if (type.getUTITypeName().equals("public.jpeg")) {
                isVerified = true;
                JPEGParser parser = ImageDescriptionGenerator.parseJPEG(sdi);
                List<ValidationIssue> issues = parser.getValidationIssues();
                for (ValidationIssue issue : issues) {
                    if (issue.getSeverity() == ValidationIssue.Severity.FATAL) {
                        listener.error(new ValidationError(issue.getMsg(), issue.getCode()));
                        isVerified = false;
                        continue;
                    }
                    if (issue.getSeverity() == ValidationIssue.Severity.MAJOR) {
                        isVerified = false;
                        listener.warning(new ValidationWarning(issue.getMsg(), issue.getCode()));
                        continue;
                    }
                    if (issue.getSeverity() != ValidationIssue.Severity.MINOR) continue;
                    listener.info(new ValidationInfo(issue.getMsg(), issue.getCode()));
                }
            } else if (type.getUTITypeName().equals("public.png")) {
                isVerified = true;
                PNGParser parser = ImageDescriptionGenerator.parsePNG(sdi);
                List<ValidationIssue> issues = parser.getValidationIssues();
                for (ValidationIssue issue : issues) {
                    if (issue.getSeverity() == ValidationIssue.Severity.FATAL) {
                        listener.error(new ValidationError(issue.getMsg(), issue.getCode()));
                        isVerified = false;
                        continue;
                    }
                    if (issue.getSeverity() == ValidationIssue.Severity.MAJOR) {
                        listener.warning(new ValidationWarning(issue.getMsg(), issue.getCode()));
                        isVerified = false;
                        continue;
                    }
                    if (issue.getSeverity() != ValidationIssue.Severity.MINOR) continue;
                    listener.info(new ValidationInfo(issue.getMsg(), issue.getCode()));
                }
            } else if (type.getUTITypeName().equals("public.tiff")) {
                isVerified = true;
                byte[] tiffHeader = new byte[4];
                sdi.readFully(tiffHeader);
                if (!Arrays.equals(tiffHeader, TIFF_HEADER_INTEL) && !Arrays.equals(tiffHeader, TIFF_HEADER_MOTOROLA)) {
                    isVerified = false;
                    listener.error(new ValidationError("Containertype doesn't match TIFF", MediaValidationCode.IMG_CONTAINER_INCOMPATIBLE));
                }
            }
            return isVerified;
        }
        catch (EOFException eofe) {
            ValidationError error = new ValidationError("We reached the end of the file before we expected. Image is likely corrupt", MediaValidationCode.IMG_APPEARS_CORRUPT);
            listener.error(error);
            return false;
        }
        catch (Exception e) {
            if (listener != null) {
                ValidationError error = new ValidationError("An unknown error occured while parsing. Image is likely corrupt.  Exception message: " + e.getMessage(), MediaValidationCode.IMG_UNKNOWN_ERROR);
                listener.error(error);
            }
            return false;
        }
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn Image Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public static void main(String[] args) throws Exception {
        String fileName = args[0];
        UniformTypeIdentifier uti = UniformTypeIdentifier.byFileName((String)fileName, (UniformTypeIdentifier)UniformTypeIdentifier.PUBLIC_DATA);
        UniformTypeIdentiferContainerTypeAdaptor containerType = new UniformTypeIdentiferContainerTypeAdaptor(uti);
        ImageDescriberVerifier describer = new ImageDescriberVerifier();
        URI uri = ContainerContainerDescriberRunner.uriForString(fileName, true);
        SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)uri);
        if (!describer.verifyContainerType(sdi, (ContainerType)containerType, null)) {
            System.out.println("verifyContainerType failed");
        } else {
            System.out.println("uti: " + uti);
            System.out.println("containerType: " + containerType);
            ContainerDescription<Node> description = describer.describe(uri, (ContainerType)new UniformTypeIdentiferContainerTypeAdaptor(uti));
            System.out.println(XMLUtil.nodeToString((Node)description.getDescriptionDocument()));
        }
    }
}

