/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.LeghornValidationContextImpl;
import com.apple.jingle.leghorn.beans.dolby.contentmapping.DolbyContentMappingDocument;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyContentMap;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.UniformTypeIdentiferContainerTypeAdaptor;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SimpleContainerDescription;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.beans.DescriberInformation;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.util.XmlBeansHelper;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableInputStream;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DolbyContentMapperDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        LeghornValidationContextImpl ctx = new LeghornValidationContextImpl(sdi.getFileName(), UniformTypeIdentifier.COM_DOLBY_CONTENTMAPPING, this.getToolName(), this.getToolVersion());
        return this.describe(ctx, sdi, type);
    }

    public ContainerDescription<Node> describe(LeghornValidationContext ctx, SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((InputStream)new SeekableInputStream(sdi), XmlBeansHelper.getXmlOptionsWithDisabledXXE());
            XmlObjectMediaParser parser = new XmlObjectMediaParser(ctx, ctx.getMediaName(), xmlObject);
            XmlOptions xmlOptions = new XmlOptions().setSavePrettyPrint();
            DolbyContentMappingDocument xmlDoc = DolbyContentMappingDocument.Factory.newInstance((XmlOptions)xmlOptions);
            DolbyContentMappingDocument.DolbyContentMapping xmlCm = xmlDoc.addNewDolbyContentMapping();
            DescriberInformation describerInformation = xmlCm.addNewDescriber();
            describerInformation.newCursor().insertNamespace("c", "http://contentmapping.dolby.beans.leghorn.jingle.apple.com");
            describerInformation.newCursor().insertNamespace("ma", "http://beans.media.leghorn.jingle.apple.com");
            describerInformation.setName(ctx.getDescriptionToolName());
            describerInformation.setVersion(ctx.getDescriptionToolVersion());
            XmlObjectMediaParser child = parser.child("DolbyLabsMDF");
            if (child != null) {
                DolbyContentMap cm = new DolbyContentMap(ctx, child);
                cm.generateDescription(ctx, xmlCm);
            } else {
                ctx.addCheckAlert(MediaValidationCode.FILE_APPEARS_CORRUPT, MediaUtil.dictionary.add("expecting", "DolbyLabsMDF").add("got", "nothing"));
            }
            if (ctx.hasValidations(ValidationLevel.DEBUG)) {
                ctx.populateAlertList(xmlCm.addNewNotifications(), ValidationLevel.DEBUG);
            }
            return DolbyContentMapperDescriberVerifier.setupContainerDescription(type, (XmlObject)xmlDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DescriptionException(e);
        }
    }

    public static ContainerDescription<Node> setupContainerDescription(ContainerType type, XmlObject o) throws IOException, ParserConfigurationException, SAXException {
        StringWriter sw = new StringWriter();
        o.save(sw);
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        String documentEncoding = "UTF-8";
        if (o.documentProperties().getEncoding() != null) {
            documentEncoding = o.documentProperties().getEncoding();
        }
        Document descriptionXml = db.parse(new ByteArrayInputStream(sw.getBuffer().toString().getBytes(documentEncoding)));
        SimpleContainerDescription description = new SimpleContainerDescription();
        description.setDescriptionDocument(descriptionXml);
        return description;
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            LeghornValidationContextImpl ctx = new LeghornValidationContextImpl(sdi.getFileName(), UniformTypeIdentifier.COM_DOLBY_CONTENTMAPPING, this.getToolName(), this.getToolVersion());
            this.describe(ctx, sdi, type);
            if (null != listener) {
                ctx.notifyListener(listener);
            }
            return !ctx.hasValidations(MediaValidationCode.FILE_APPEARS_CORRUPT, MediaValidationCode.MOV_CONTAINER_INCOMPATIBLE);
        }
        catch (DescriptionException e) {
            ValidationError error = e.getError() == null ? new ValidationError(e.getMessage(), MediaValidationCode.FILE_APPEARS_CORRUPT) : e.getError();
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn Dolby Content Mapping Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    public static void main(String[] args) throws Exception {
        UniformTypeIdentifier uti = UniformTypeIdentifier.COM_DOLBY_CONTENTMAPPING;
        UniformTypeIdentiferContainerTypeAdaptor containerType = new UniformTypeIdentiferContainerTypeAdaptor(uti);
        DolbyContentMapperDescriberVerifier describer = new DolbyContentMapperDescriberVerifier();
        SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)ContainerContainerDescriberRunner.uriForString(args[0], true));
        if (!describer.verifyContainerType(sdi, (ContainerType)containerType, null)) {
            System.out.println("verifyContainerType failed");
        } else {
            ContainerContainerDescriberRunner.main(new DolbyContentMapperDescriberVerifier(), uti, args);
        }
    }
}

