/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.LeghornValidationContextImpl;
import com.apple.jingle.leghorn.audio.RIFF.DescriptionListData;
import com.apple.jingle.leghorn.audio.caf.CAChannelLayoutTag;
import com.apple.jingle.leghorn.audio.caf.CAFFile;
import com.apple.jingle.leghorn.audio.caf.CAFParser;
import com.apple.jingle.leghorn.audio.caf.beans.CafDescriptionDocument;
import com.apple.jingle.leghorn.audio.caf.beans.DataRate;
import com.apple.jingle.leghorn.audio.caf.beans.DataSize;
import com.apple.jingle.leghorn.audio.caf.beans.Description;
import com.apple.jingle.leghorn.audio.caf.beans.DialogueAnchor;
import com.apple.jingle.leghorn.audio.caf.beans.Duration2;
import com.apple.jingle.leghorn.audio.caf.beans.ExtraDescriptions;
import com.apple.jingle.leghorn.audio.caf.beans.InfoDictionary;
import com.apple.jingle.leghorn.audio.caf.beans.PacketTable;
import com.apple.jingle.leghorn.audio.caf.beans.SampleRate2;
import com.apple.jingle.leghorn.audio.caf.beans.SoundcheckInfo;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.UniformTypeIdentiferContainerTypeAdaptor;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.DescriptionDocumentUtilities;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import com.apple.jingle.leghorn.media.beans.NotificationList;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.util.PlistParser;
import com.apple.jingle.leghorn.util.javacc.ParseException;
import com.apple.jingle.locale.BCP47TagMediator;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.LocaleCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CoreAudioDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    private String schemaName;

    @Override
    public String getToolName() {
        return "FoghornLeghorn CAF Parser";
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            this.describe(sdi, type);
        }
        catch (DescriptionException e) {
            ValidationError error = null;
            if (e.getError() != null) {
                error = new ValidationError(e.getMessage());
            }
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        LeghornValidationContextImpl ctx = new LeghornValidationContextImpl(sdi.getFileName(), UniformTypeIdentifier.COM_APPLE_COREAUDIO_FORMAT, this.getToolName(), this.getToolVersion());
        CAFParser parser = new CAFParser();
        CAFFile cafFile = parser.parseFile((LeghornValidationContext)ctx, sdi);
        CafDescriptionDocument doc = CafDescriptionDocument.Factory.newInstance();
        CafDescriptionDocument.CafDescription desc = doc.addNewCafDescription();
        this.writeBasicDesciptionAttributes(desc.newCursor(), desc.addNewDescriber());
        desc.setFileSize(sdi.length());
        if (cafFile.hasValidDescriptionChunk()) {
            desc.setCodec(cafFile.formatID());
            SampleRate2 sampleRate = desc.addNewSampleRate();
            sampleRate.setUnits("hertz");
            sampleRate.setFloatValue((float)cafFile.sampleRate());
            Duration2 duration = desc.addNewDuration();
            duration.setUnits("seconds");
            duration.setStringValue(String.valueOf(cafFile.durationSeconds()));
            desc.setIsCompressedFormat(cafFile.isCompressedFormat());
            desc.setIsVariableBitRate(cafFile.isVariableBitRate());
            desc.setIsVariableFramePerPacket(cafFile.isVariableFramePerPacket());
            desc.setChannelCount(BigInteger.valueOf(cafFile.channelsPerFrame()));
            desc.setChannelLayout(cafFile.channelLayout());
            long bitsPerChannel = cafFile.bitsPerChannel();
            if ("alac".equals(cafFile.formatID())) {
                long formatFlags = cafFile.formatFlag();
                if (formatFlags == 1L) {
                    bitsPerChannel = 16L;
                } else if (formatFlags == 2L) {
                    bitsPerChannel = 20L;
                } else if (formatFlags == 3L) {
                    bitsPerChannel = 24L;
                } else if (formatFlags == 4L) {
                    bitsPerChannel = 32L;
                }
            }
            desc.setBitDepth(BigInteger.valueOf(bitsPerChannel));
            desc.setSampleFormat(cafFile.getSampleFormat());
            DataRate dataRate = desc.addNewDataRate();
            dataRate.setUnits("Kb/s");
            dataRate.setFloatValue((float)cafFile.dataRate());
            DataSize dataSize = desc.addNewDataSize();
            dataSize.setUnits("bytes");
            dataSize.setBigIntegerValue(BigInteger.valueOf(cafFile.dataSize()));
        }
        this.addPacketTable(desc, cafFile);
        this.addDescriptionList(desc, cafFile);
        this.addInfoEntry(desc, cafFile);
        this.addSoundcheckInfo(desc, cafFile);
        NotificationList notificationList = desc.getNotifications();
        if (notificationList == null) {
            notificationList = desc.addNewNotifications();
        }
        ctx.populateAlertList(notificationList, ValidationLevel.INFO);
        try {
            return new SingleStreamContainerDescription(doc.getDomNode(), "CoreAudio File", (LocaleCode)BCP47TagMediator.createBCP47Tag((String)"en"), type);
        }
        catch (BCP47TagParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private CafDescriptionDocument.CafDescription addSoundcheckInfo(CafDescriptionDocument.CafDescription desc, CAFFile cafFile) {
        if (cafFile.hasSoundcheckData()) {
            PlistParser parser = new PlistParser();
            try {
                Map da;
                BigDecimal val;
                Map ml;
                Map scDict = (Map)parser.parse(new StringReader(cafFile.soundcheckData()));
                if (scDict.containsKey("main loudness parameters") && (ml = (Map)scDict.get("main loudness parameters")) != null) {
                    SoundcheckInfo scinfo = desc.addNewSoundcheckInfo();
                    val = (BigDecimal)ml.get("aa ebu top of loudness range");
                    if (val != null) {
                        scinfo.setEbuLoudnessRangeTopKey(val.doubleValue());
                    }
                    if ((val = (BigDecimal)ml.get("aa ebu max momentary loudness")) != null) {
                        scinfo.setEbuMaxMomentaryLoudnessKey(val.doubleValue());
                    }
                    if ((val = (BigDecimal)ml.get("aa ebu max short-term loudness")) != null) {
                        scinfo.setEbuMaxShortTermLoudnessKey(val.doubleValue());
                    }
                    if ((val = (BigDecimal)ml.get("aa ebu loudness range")) != null) {
                        scinfo.setEbuLoudnessRangeKey(val.doubleValue());
                    }
                    if ((val = (BigDecimal)ml.get("aa itu loudness")) != null) {
                        scinfo.setItuLoudnessKey(val.doubleValue());
                    }
                    if ((val = (BigDecimal)ml.get("aa itu true peak")) != null) {
                        scinfo.setItuTruePeakKey(val.doubleValue());
                    }
                }
                if (scDict.containsKey("dialogue anchor parameters") && (da = (Map)scDict.get("dialogue anchor parameters")) != null) {
                    DialogueAnchor dialogueAnchor = desc.addNewDialogueAnchor();
                    val = (BigDecimal)da.get("aa ebu loudness range");
                    if (val != null) {
                        dialogueAnchor.setEbuLoudnessRangeKey(val.doubleValue());
                    }
                    if ((val = (BigDecimal)da.get("aa itu loudness")) != null) {
                        dialogueAnchor.setItuLoudnessKey(val.doubleValue());
                    }
                    if ((val = (BigDecimal)da.get("aa speech activity percentage")) != null) {
                        dialogueAnchor.setSpeechActivityPercentageKey(val.doubleValue());
                    }
                }
            }
            catch (ParseException | IOException e) {
                // empty catch block
            }
        }
        return desc;
    }

    private CafDescriptionDocument.CafDescription addInfoEntry(CafDescriptionDocument.CafDescription document, CAFFile cafFile) {
        if (cafFile.infoEntryCount() > 0) {
            InfoDictionary info = document.addNewInfoDictionary();
            XmlCursor cursor1 = info.newCursor();
            cursor1.toEndToken();
            for (Map.Entry<String, String> kv : cafFile.info().entrySet()) {
                cursor1.insertElementWithText(kv.getKey().replaceAll(" ", "_"), kv.getValue());
            }
        }
        return document;
    }

    private CafDescriptionDocument.CafDescription addDescriptionList(CafDescriptionDocument.CafDescription document, CAFFile cafFile) {
        if (cafFile.descriptionListSize() > 0) {
            ExtraDescriptions extraDescriptions = document.addNewExtraDescriptions();
            for (DescriptionListData de : cafFile.descriptionList()) {
                Description desc = extraDescriptions.addNewDescription();
                desc.setCodec(de._formatID);
                desc.setChannelCount(BigInteger.valueOf(de._channelsPerFrame));
                SampleRate2 sampleRate = desc.addNewSampleRate();
                sampleRate.setUnits("hertz");
                sampleRate.setFloatValue((float)de._sampleRate);
                desc.setChannelLayout(CAChannelLayoutTag.nameFromLong(de._channelLayoutTag));
            }
        }
        return document;
    }

    private CafDescriptionDocument.CafDescription addPacketTable(CafDescriptionDocument.CafDescription document, CAFFile cafFile) {
        if (cafFile.numberPackets() == -1L || cafFile.numberValidFrames() == -1L || cafFile.primingFrames() == -1 || cafFile.remainderFrames() == -1) {
            return document;
        }
        PacketTable packetTable = document.addNewPacketTable();
        packetTable.setNumberPackets(cafFile.numberPackets());
        packetTable.setNumberValidFrames(cafFile.numberValidFrames());
        packetTable.setPrimingFrames(BigInteger.valueOf(cafFile.primingFrames()));
        packetTable.setRemainderFrames(BigInteger.valueOf(cafFile.remainderFrames()));
        return document;
    }

    private Document generateNotificationList(Document document, String rootNodeName, LeghornValidationContext ctx) {
        if (ctx.hasValidations(ValidationLevel.DEBUG)) {
            String root = "notifications";
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, root, "");
            int index = 0;
            for (ValidationResult result : ctx.getValidations()) {
                document = this.addNotification(document, root, result, index);
                ++index;
            }
        }
        return document;
    }

    private Document addNotification(Document document, String root, ValidationResult result, int index) {
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("code", result.getValidationCode());
        attr.put("level", result.getValidationLevel().name());
        document = DescriptionDocumentUtilities.addDescriptionWithAttribute(document, root, "notification", "", attr);
        document = DescriptionDocumentUtilities.addDescriptionWithAttributeAtIndex(document, "notification", "parameters", "", Collections.emptyMap(), index);
        document = DescriptionDocumentUtilities.addDescriptionWithAttributeAtIndex(document, "parameters", "entry", result.getDefaultMessage(), Collections.singletonMap("key", "message"), index);
        return document;
    }

    private Document addPacketTable2(Document document, String rootNodeName, CAFFile cafFile) {
        if (cafFile.numberPackets() == -1L || cafFile.numberValidFrames() == -1L || cafFile.primingFrames() == -1 || cafFile.remainderFrames() == -1) {
            return document;
        }
        String packetTableInfoName = "packetTable";
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, packetTableInfoName, "");
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, packetTableInfoName, "numberPackets", cafFile.numberPackets());
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, packetTableInfoName, "numberValidFrames", cafFile.numberValidFrames());
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, packetTableInfoName, "primingFrames", cafFile.primingFrames());
        document = DescriptionDocumentUtilities.addDescriptionAttribute(document, packetTableInfoName, "remainderFrames", cafFile.remainderFrames());
        return document;
    }

    private Document addInfoEntry2(Document document, String rootNodeName, CAFFile cafFile) {
        if (cafFile.infoEntryCount() > 0) {
            String infoDictionaryName = "infoDictionary";
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, infoDictionaryName, "");
            for (Map.Entry<String, String> kv : cafFile.info().entrySet()) {
                document = DescriptionDocumentUtilities.addDescriptionAttribute(document, infoDictionaryName, kv.getKey().replaceAll(" ", "_"), kv.getValue());
            }
        }
        return document;
    }

    private Document addDescriptionList2(Document document, String rootNodeName, CAFFile cafFile) {
        if (cafFile.descriptionListSize() > 0) {
            String extraDescriptionsName = "extra_descriptions";
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, extraDescriptionsName, "");
            int descIndex = 0;
            for (DescriptionListData de : cafFile.descriptionList()) {
                String extraDescription = "description";
                document = DescriptionDocumentUtilities.addDescriptionAttribute(document, extraDescriptionsName, extraDescription, "");
                document = DescriptionDocumentUtilities.addDescriptionAttributeAtIndex(document, extraDescription, "codec", de._formatID, descIndex);
                document = DescriptionDocumentUtilities.addDescriptionWithAttributeAtIndex(document, extraDescription, "sample_rate", String.valueOf(de._sampleRate), Collections.singletonMap("units", "hertz"), descIndex);
                document = DescriptionDocumentUtilities.addDescriptionWithAttributeAtIndex(document, extraDescription, "channel_count", String.valueOf(de._channelsPerFrame), Collections.singletonMap("units", "hertz"), descIndex);
                document = DescriptionDocumentUtilities.addDescriptionAttributeAtIndex(document, extraDescription, "channel_layout", CAChannelLayoutTag.nameFromLong(de._channelLayoutTag), descIndex);
                ++descIndex;
            }
        }
        return document;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public static void main(String[] args) throws Exception {
        UniformTypeIdentifier uti = UniformTypeIdentifier.COM_APPLE_COREAUDIO_FORMAT;
        UniformTypeIdentiferContainerTypeAdaptor containerType = new UniformTypeIdentiferContainerTypeAdaptor(uti);
        CoreAudioDescriberVerifier describer = new CoreAudioDescriberVerifier();
        URI uri = ContainerContainerDescriberRunner.uriForString(args[0], true);
        SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)uri);
        if (!describer.verifyContainerType(sdi, (ContainerType)containerType, null)) {
            System.out.println("verifyContainerType failed");
        } else {
            ContainerContainerDescriberRunner.main(new CoreAudioDescriberVerifier(), uti, args);
        }
    }
}

