/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.InputStreamContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

public class CompressorSettingsDescriberVerifier
extends InputStreamContainerDescriberVerifier {
    private String schemaName;

    @Override
    public ContainerDescription<Node> describe(BufferedInputStream bif, ContainerType type) throws IOException, DescriptionException {
        try {
            XmlObject parsedDescription = XmlObject.Factory.parse(bif);
            return new SingleStreamContainerDescription(parsedDescription.getDomNode(), "Compressor Settings", null, type);
        }
        catch (XmlException e) {
            throw new DescriptionException(e);
        }
    }

    @Override
    protected boolean verifyContainerType(BufferedInputStream bif, ContainerType type, ValidationListener listener) throws IOException {
        try {
            XmlObject parsedDescription = XmlObject.Factory.parse(bif);
            return null != parsedDescription;
        }
        catch (XmlException e) {
            XmlError xmlError = e.getError();
            ValidationError error = xmlError != null ? new ValidationError(e.getMessage(), xmlError.getOffset(), xmlError.getLine(), xmlError.getColumn()) : new ValidationError(e.getMessage());
            if (listener != null) {
                listener.error(error);
            }
            return false;
        }
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn Compressor Settings Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

