/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.chapters.BaseChaptersDocument;
import com.apple.jingle.leghorn.chapters.ChaptersDocument;
import com.apple.jingle.leghorn.chapters.ChaptersDocumentException;
import com.apple.jingle.leghorn.chapters.ChaptersDocumentV1Impl;
import com.apple.jingle.leghorn.chapters.ChaptersDocumentV2Impl;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.DescriptionDocumentUtilities;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import com.apple.jingle.locale.BCP47TagMediator;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.LocaleCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class ChaptersDocumentDescriberVerifier
extends SeekableDataInputContainerDescriberVerifier {
    public String getSchemaName() {
        return "ChaptersDescription.xsd";
    }

    public void setSchemaName(String schemaName) {
    }

    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        try {
            ChaptersDocument chaptersDocument = BaseChaptersDocument.createFromChaptersXML(sdi, false);
            String rootNodeName = "chapters_description";
            Document document = DescriptionDocumentUtilities.constructBasicDescription(rootNodeName, sdi.length(), Configuration.getVersion());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "firstTimeCode", chaptersDocument.getFirstTimeCode().toUserString());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "lastTimeCode", chaptersDocument.getLastTimeCode().toUserString());
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "numberOfChapters", Integer.toString(chaptersDocument.getNumberOfChapters()));
            document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "imagesPresent", Boolean.toString(chaptersDocument.isImagesPresent()));
            if (chaptersDocument instanceof ChaptersDocumentV2Impl) {
                document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "frameRate", chaptersDocument.getFrameRateFormatString());
                document = DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, "timeCodeFormat", chaptersDocument.getTimeCodeFormat());
            }
            Node rootNode = document.getElementsByTagName(rootNodeName).item(0);
            String artworkTimeChaptersNodeName = "generatedArtwork";
            int count = 0;
            Element artworkTimeChaptersNode = document.createElement(artworkTimeChaptersNodeName);
            rootNode.appendChild(artworkTimeChaptersNode);
            String chaptersNodeName = "chapters";
            Element chaptersNode = document.createElement(chaptersNodeName);
            rootNode.appendChild(chaptersNode);
            for (ChaptersDocument.Chapter chapter : chaptersDocument.getChapters()) {
                Element chapterNode = document.createElement("chapter");
                chaptersNode.appendChild(chapterNode);
                if (chapter.getStartTime() != null) {
                    chapterNode.setAttribute("start_time", chapter.getStartTime().toUserString());
                }
                if (chapter.getImageTimeCode() == null) continue;
                ++count;
                String timeCode = chapter.getImageTimeCode().toUserString();
                document = DescriptionDocumentUtilities.addDescriptionAttribute(document, artworkTimeChaptersNodeName, "timeCode", timeCode);
                chapterNode.setAttribute("artwork_time", timeCode);
            }
            artworkTimeChaptersNode.setAttribute("count", Integer.toString(count));
            return new SingleStreamContainerDescription(document, "Chapters", (LocaleCode)BCP47TagMediator.createBCP47Tag((String)"en"), type);
        }
        catch (ChaptersDocumentException cde) {
            if (cde.getCause() instanceof SAXParseException) {
                SAXParseException parseException = (SAXParseException)cde.getCause();
                throw new DescriptionException(cde.getMessage(), new ValidationError(cde.getMessage(), -1L, parseException.getLineNumber(), parseException.getColumnNumber()));
            }
            throw new DescriptionException(cde);
        }
        catch (BCP47TagParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean verifyContainerType(SeekableDataInput sdi, ContainerType type, ValidationListener listener) throws IOException {
        try {
            ChaptersDocument chaptersDocument = ChaptersDocumentV1Impl.createFromChaptersXML(sdi, false);
            return null != chaptersDocument;
        }
        catch (ChaptersDocumentException cde) {
            if (listener != null) {
                if (cde.getCause() instanceof SAXParseException) {
                    SAXParseException parseException = (SAXParseException)cde.getCause();
                    listener.error(new ValidationError(cde.getMessage(), -1L, parseException.getLineNumber(), parseException.getColumnNumber()));
                } else {
                    listener.error(new ValidationError(cde.getMessage()));
                }
            }
            return false;
        }
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn Chapters XML Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }
}

