/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl.types;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberBase;
import com.apple.jingle.leghorn.fileformat.impl.SingleStreamContainerDescription;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class A52AudioContainerDescriber
extends SeekableDataInputContainerDescriberBase<Node> {
    private static final byte[] B_syncword = new byte[]{11, 119};
    private static final Map T_fscod = new HashMap(4);
    private static final Map T_bsmod = new HashMap(9);
    private static final Map T_acmod = new HashMap(8);
    private static final Map T_nfchans = new HashMap(8);
    private static final Map T_acmod_chord = new HashMap(8);
    private static final Map T_frmsizecod = new HashMap(10);
    private static final Map T_dsurmod = new HashMap(4);
    private static final Map T_wsf32 = new HashMap();
    private static final Map T_wsf441 = new HashMap();
    private static final Map T_wsf48 = new HashMap();
    private static final Map T_frmsizecod_ws = new HashMap(3);
    private static final long SAMPLES_PER_FRAME = 1536L;
    private static final int SYNCINFO_SEEK_RANGE = 512;
    private static final String UTI_PUBLIC_AC3_AUDIO = "public.ac3-audio";
    protected static final Logger LOG = Logger.getLogger(A52AudioContainerDescriber.class);

    private static Byte asByte(String i) {
        return Byte.valueOf(i, 2);
    }

    private static Byte asByte(int i) {
        return (byte)i;
    }

    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        Map a52Info;
        try {
            a52Info = this.describeA52(sdi);
        }
        catch (IOException ioe) {
            throw new DescriptionException(ioe);
        }
        return this.asContainerDescription(a52Info, type);
    }

    private ContainerDescription<Node> asContainerDescription(Map a52Info, ContainerType type) throws DescriptionException {
        Node description;
        try {
            description = this.createDescription(a52Info);
        }
        catch (Exception e) {
            throw new DescriptionException(e);
        }
        return new SingleStreamContainerDescription(description, "sound", null, type);
    }

    private Node createDescription(Map a52Info) throws Exception {
        DOMImplementation impl = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        Document xmldoc = impl.createDocument(null, "container", null);
        Element rootElement = xmldoc.getDocumentElement();
        rootElement.setAttributeNS(null, "name", UTI_PUBLIC_AC3_AUDIO);
        Element streamElement = xmldoc.createElementNS(null, "stream");
        rootElement.appendChild(streamElement);
        streamElement.setAttributeNS(null, "format", "audio.ac-3");
        streamElement.setAttributeNS(null, "endian", a52Info.get("_endian").toString());
        streamElement.setAttributeNS(null, "bytes", a52Info.get("bytes").toString());
        if (a52Info.get("duration") != null) {
            streamElement.setAttributeNS(null, "duration", a52Info.get("duration").toString());
            Element soundElement = xmldoc.createElementNS(null, "sound");
            streamElement.appendChild(soundElement);
            String sample_rate = Integer.toString((int)(((Float)a52Info.get("fscod")).floatValue() * 1000.0f));
            soundElement.setAttributeNS(null, "sample_rate", sample_rate);
            soundElement.setAttributeNS(null, "channels", a52Info.get("nfchans").toString());
            Element ac3Element = xmldoc.createElementNS(null, "ac3");
            streamElement.appendChild(ac3Element);
            ac3Element.setAttributeNS(null, "audio_coding_mode", (String)a52Info.get("acmod"));
            ac3Element.setAttributeNS(null, "nominal_bitrate", (String)a52Info.get("_nominal_bitrate"));
            ac3Element.setAttributeNS(null, "dolby_surround", (String)a52Info.get("dsurmod"));
            ac3Element.setAttributeNS(null, "lfe_on", a52Info.get("lfeon").toString());
            ac3Element.setAttributeNS(null, "bit_stream_mode", (String)a52Info.get("bsmod"));
            ac3Element.setAttributeNS(null, "acmod_chord", (String)a52Info.get("acmod_chord"));
            ac3Element.setAttributeNS(null, "frames", a52Info.get("frames").toString());
            ac3Element.setAttributeNS(null, "bsid", a52Info.get("bsid").toString());
        }
        return xmldoc;
    }

    private Map describeA52(SeekableDataInput raf) throws IOException, DescriptionException {
        raf.seek(0L);
        long fileLength = raf.length();
        HashMap<String, Long> attributes = new HashMap<String, Long>();
        attributes.put("bytes", raf.length());
        long frames = 0L;
        long position = 0L;
        float duration = 0.0f;
        while (position < fileLength) {
            try {
                long headerLength = this.syncinfo(raf, attributes);
                if (attributes.get("_endian").equals("LE")) {
                    return attributes;
                }
                position += headerLength;
                Object frameSizeCodeTableForFs = T_frmsizecod_ws.get(attributes.get("fscod"));
                Object wordSizeForFrmSizeCod = ((Map)frameSizeCodeTableForFs).get(attributes.get("frmsizecod"));
                attributes.put("duration", (long)(duration += 1536.0f / ((Float)attributes.get("fscod")).floatValue()));
                attributes.put("frames", ++frames);
                raf.seek(position += (long)((Integer)wordSizeForFrmSizeCod * 2));
            }
            catch (RuntimeException rte) {
                LOG.fatal((Object)rte);
                throw new DescriptionException(rte);
            }
        }
        return attributes;
    }

    private int syncinfo(SeekableDataInput raf, Map attributes) throws IOException, DescriptionException {
        long bytesRemaining = raf.length() - raf.getFilePointer();
        byte[] header = new byte[512L <= bytesRemaining ? 512 : (int)bytesRemaining];
        raf.readFully(header);
        if (header[0] == B_syncword[1] && header[1] == B_syncword[0]) {
            attributes.put("_endian", "LE");
            return 0;
        }
        attributes.put("_endian", "BE");
        int found = -1;
        for (int position = 0; position < header.length - 1; ++position) {
            if (LOG.isDebugEnabled() && position > 0) {
                LOG.debug((Object)(position + ": " + Integer.toHexString(header[position]) + Integer.toHexString(header[position + 1])));
            }
            if (header[position] != B_syncword[0] || header[position + 1] != B_syncword[1]) continue;
            found = position;
            break;
        }
        if (found == -1) {
            throw new DescriptionException(new ValidationError("Did not locate syncheader within range: 512; attributes=" + attributes, raf.getFilePointer()));
        }
        System.arraycopy(header, found, header, 0, 8);
        byte[] syncword = new byte[]{header[0], header[1]};
        if (!Arrays.equals(syncword, B_syncword)) {
            throw new DescriptionException(new ValidationError("Unexpected bytes at syncword: " + Integer.toHexString(syncword[0]) + Integer.toHexString(syncword[1]), raf.getFilePointer()));
        }
        attributes.put("syncword", Boolean.TRUE);
        int byte4 = A52AudioContainerDescriber.unsignedByteToInt(header[4]);
        attributes.put("fscod", T_fscod.get(A52AudioContainerDescriber.asByte(byte4 >>> 6)));
        attributes.put("frmsizecod", A52AudioContainerDescriber.asByte(byte4 & 0x3F));
        attributes.put("_nominal_bitrate", T_frmsizecod.get(A52AudioContainerDescriber.asByte(byte4 & 0x3F)));
        int byte5 = A52AudioContainerDescriber.unsignedByteToInt(header[5]);
        attributes.put("bsid", A52AudioContainerDescriber.asByte(byte5 >>> 3));
        int bsmod = A52AudioContainerDescriber.unsignedByteToInt(header[5]);
        attributes.put("bsmod", T_bsmod.get(A52AudioContainerDescriber.asByte(bsmod & 7)));
        int byte6 = A52AudioContainerDescriber.unsignedByteToInt(header[6]);
        int byte7 = A52AudioContainerDescriber.unsignedByteToInt(header[7]);
        int acmod = byte6 >>> 5;
        attributes.put("acmod", T_acmod.get(A52AudioContainerDescriber.asByte(acmod)));
        attributes.put("nfchans", T_nfchans.get(A52AudioContainerDescriber.asByte(acmod)));
        attributes.put("acmod_chord", T_acmod_chord.get(A52AudioContainerDescriber.asByte(acmod)));
        if (acmod == 2) {
            int dsurmod = (byte6 & 1) << 1 | (byte7 & 0x80) >>> 7;
            attributes.put("dsurmod", T_dsurmod.get(A52AudioContainerDescriber.asByte(dsurmod)));
        } else {
            attributes.put("dsurmod", "N/A");
        }
        int lfeon = byte7 & 0x40;
        attributes.put("lfeon", lfeon == 0 ? Boolean.FALSE : Boolean.TRUE);
        return found;
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn AC3 Parser";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    static {
        T_fscod.put(A52AudioContainerDescriber.asByte(0), Float.valueOf(48.0f));
        T_fscod.put(A52AudioContainerDescriber.asByte(1), Float.valueOf(44.1f));
        T_fscod.put(A52AudioContainerDescriber.asByte(2), Float.valueOf(32.0f));
        T_fscod.put(A52AudioContainerDescriber.asByte(3), "reserved");
        T_bsmod.put(A52AudioContainerDescriber.asByte(0), "CM");
        T_bsmod.put(A52AudioContainerDescriber.asByte(1), "ME");
        T_bsmod.put(A52AudioContainerDescriber.asByte(2), "VI");
        T_bsmod.put(A52AudioContainerDescriber.asByte(3), "HI");
        T_bsmod.put(A52AudioContainerDescriber.asByte(4), "D");
        T_bsmod.put(A52AudioContainerDescriber.asByte(5), "C");
        T_bsmod.put(A52AudioContainerDescriber.asByte(6), "E");
        T_bsmod.put(A52AudioContainerDescriber.asByte(7), "VO");
        T_acmod.put(A52AudioContainerDescriber.asByte(0), "1+1");
        T_acmod.put(A52AudioContainerDescriber.asByte(1), "1/0");
        T_acmod.put(A52AudioContainerDescriber.asByte(2), "2/0");
        T_acmod.put(A52AudioContainerDescriber.asByte(3), "3/0");
        T_acmod.put(A52AudioContainerDescriber.asByte(4), "2/1");
        T_acmod.put(A52AudioContainerDescriber.asByte(5), "3/1");
        T_acmod.put(A52AudioContainerDescriber.asByte(6), "2/2");
        T_acmod.put(A52AudioContainerDescriber.asByte(7), "3/2");
        T_nfchans.put(A52AudioContainerDescriber.asByte(0), 2);
        T_nfchans.put(A52AudioContainerDescriber.asByte(1), 1);
        T_nfchans.put(A52AudioContainerDescriber.asByte(2), 2);
        T_nfchans.put(A52AudioContainerDescriber.asByte(3), 3);
        T_nfchans.put(A52AudioContainerDescriber.asByte(4), 3);
        T_nfchans.put(A52AudioContainerDescriber.asByte(5), 4);
        T_nfchans.put(A52AudioContainerDescriber.asByte(6), 4);
        T_nfchans.put(A52AudioContainerDescriber.asByte(7), 5);
        T_acmod_chord.put(A52AudioContainerDescriber.asByte(0), "Ch1, Ch2");
        T_acmod_chord.put(A52AudioContainerDescriber.asByte(1), "C");
        T_acmod_chord.put(A52AudioContainerDescriber.asByte(2), "L, R");
        T_acmod_chord.put(A52AudioContainerDescriber.asByte(3), "L, C, R");
        T_acmod_chord.put(A52AudioContainerDescriber.asByte(4), "L, R, S");
        T_acmod_chord.put(A52AudioContainerDescriber.asByte(5), "L, C, R, S");
        T_acmod_chord.put(A52AudioContainerDescriber.asByte(6), "L, R, SL, SR");
        T_acmod_chord.put(A52AudioContainerDescriber.asByte(7), "L, C, R, SL, SR");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("000000"), "32");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("000001"), "32");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("000010"), "40");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("000011"), "40");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("000100"), "48");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("000101"), "48");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("000110"), "56");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("000111"), "56");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("001000"), "64");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("001001"), "64");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("001010"), "80");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("001011"), "80");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("001100"), "96");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("001101"), "96");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("001110"), "112");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("001111"), "112");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("010000"), "128");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("010001"), "128");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("010010"), "160");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("010011"), "160");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("010100"), "192");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("010101"), "192");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("010110"), "224");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("010111"), "224");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("011000"), "256");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("011001"), "256");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("011010"), "320");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("011011"), "320");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("011100"), "384");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("011101"), "384");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("011110"), "448");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("011111"), "448");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("100000"), "512");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("100001"), "512");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("100010"), "576");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("100011"), "576");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("100100"), "640");
        T_frmsizecod.put(A52AudioContainerDescriber.asByte("100101"), "640");
        T_wsf32.put(A52AudioContainerDescriber.asByte("000000"), 96);
        T_wsf441.put(A52AudioContainerDescriber.asByte("000000"), 69);
        T_wsf48.put(A52AudioContainerDescriber.asByte("000000"), 64);
        T_wsf32.put(A52AudioContainerDescriber.asByte("000001"), 96);
        T_wsf441.put(A52AudioContainerDescriber.asByte("000001"), 70);
        T_wsf48.put(A52AudioContainerDescriber.asByte("000001"), 64);
        T_wsf32.put(A52AudioContainerDescriber.asByte("000010"), 120);
        T_wsf441.put(A52AudioContainerDescriber.asByte("000010"), 87);
        T_wsf48.put(A52AudioContainerDescriber.asByte("000010"), 80);
        T_wsf32.put(A52AudioContainerDescriber.asByte("000011"), 120);
        T_wsf441.put(A52AudioContainerDescriber.asByte("000011"), 88);
        T_wsf48.put(A52AudioContainerDescriber.asByte("000011"), 80);
        T_wsf32.put(A52AudioContainerDescriber.asByte("000100"), 144);
        T_wsf441.put(A52AudioContainerDescriber.asByte("000100"), 104);
        T_wsf48.put(A52AudioContainerDescriber.asByte("000100"), 96);
        T_wsf32.put(A52AudioContainerDescriber.asByte("000101"), 144);
        T_wsf441.put(A52AudioContainerDescriber.asByte("000101"), 105);
        T_wsf48.put(A52AudioContainerDescriber.asByte("000101"), 96);
        T_wsf32.put(A52AudioContainerDescriber.asByte("000110"), 168);
        T_wsf441.put(A52AudioContainerDescriber.asByte("000110"), 121);
        T_wsf48.put(A52AudioContainerDescriber.asByte("000110"), 112);
        T_wsf32.put(A52AudioContainerDescriber.asByte("000111"), 168);
        T_wsf441.put(A52AudioContainerDescriber.asByte("000111"), 122);
        T_wsf48.put(A52AudioContainerDescriber.asByte("000111"), 112);
        T_wsf32.put(A52AudioContainerDescriber.asByte("001000"), 192);
        T_wsf441.put(A52AudioContainerDescriber.asByte("001000"), 139);
        T_wsf48.put(A52AudioContainerDescriber.asByte("001000"), 128);
        T_wsf32.put(A52AudioContainerDescriber.asByte("001001"), 192);
        T_wsf441.put(A52AudioContainerDescriber.asByte("001001"), 140);
        T_wsf48.put(A52AudioContainerDescriber.asByte("001001"), 128);
        T_wsf32.put(A52AudioContainerDescriber.asByte("001010"), 240);
        T_wsf441.put(A52AudioContainerDescriber.asByte("001010"), 174);
        T_wsf48.put(A52AudioContainerDescriber.asByte("001010"), 160);
        T_wsf32.put(A52AudioContainerDescriber.asByte("001011"), 240);
        T_wsf441.put(A52AudioContainerDescriber.asByte("001011"), 175);
        T_wsf48.put(A52AudioContainerDescriber.asByte("001011"), 160);
        T_wsf32.put(A52AudioContainerDescriber.asByte("001100"), 288);
        T_wsf441.put(A52AudioContainerDescriber.asByte("001100"), 208);
        T_wsf48.put(A52AudioContainerDescriber.asByte("001100"), 192);
        T_wsf32.put(A52AudioContainerDescriber.asByte("001101"), 288);
        T_wsf441.put(A52AudioContainerDescriber.asByte("001101"), 209);
        T_wsf48.put(A52AudioContainerDescriber.asByte("001101"), 192);
        T_wsf32.put(A52AudioContainerDescriber.asByte("001110"), 336);
        T_wsf441.put(A52AudioContainerDescriber.asByte("001110"), 243);
        T_wsf48.put(A52AudioContainerDescriber.asByte("001110"), 224);
        T_wsf32.put(A52AudioContainerDescriber.asByte("001111"), 336);
        T_wsf441.put(A52AudioContainerDescriber.asByte("001111"), 244);
        T_wsf48.put(A52AudioContainerDescriber.asByte("001111"), 224);
        T_wsf32.put(A52AudioContainerDescriber.asByte("010000"), 384);
        T_wsf441.put(A52AudioContainerDescriber.asByte("010000"), 278);
        T_wsf48.put(A52AudioContainerDescriber.asByte("010000"), 256);
        T_wsf32.put(A52AudioContainerDescriber.asByte("010001"), 384);
        T_wsf441.put(A52AudioContainerDescriber.asByte("010001"), 279);
        T_wsf48.put(A52AudioContainerDescriber.asByte("010001"), 256);
        T_wsf32.put(A52AudioContainerDescriber.asByte("010010"), 480);
        T_wsf441.put(A52AudioContainerDescriber.asByte("010010"), 348);
        T_wsf48.put(A52AudioContainerDescriber.asByte("010010"), 320);
        T_wsf32.put(A52AudioContainerDescriber.asByte("010011"), 480);
        T_wsf441.put(A52AudioContainerDescriber.asByte("010011"), 349);
        T_wsf48.put(A52AudioContainerDescriber.asByte("010011"), 320);
        T_wsf32.put(A52AudioContainerDescriber.asByte("010100"), 576);
        T_wsf441.put(A52AudioContainerDescriber.asByte("010100"), 417);
        T_wsf48.put(A52AudioContainerDescriber.asByte("010100"), 384);
        T_wsf32.put(A52AudioContainerDescriber.asByte("010101"), 576);
        T_wsf441.put(A52AudioContainerDescriber.asByte("010101"), 418);
        T_wsf48.put(A52AudioContainerDescriber.asByte("010101"), 384);
        T_wsf32.put(A52AudioContainerDescriber.asByte("010110"), 672);
        T_wsf441.put(A52AudioContainerDescriber.asByte("010110"), 487);
        T_wsf48.put(A52AudioContainerDescriber.asByte("010110"), 448);
        T_wsf32.put(A52AudioContainerDescriber.asByte("010111"), 672);
        T_wsf441.put(A52AudioContainerDescriber.asByte("010111"), 488);
        T_wsf48.put(A52AudioContainerDescriber.asByte("010111"), 448);
        T_wsf32.put(A52AudioContainerDescriber.asByte("011000"), 768);
        T_wsf441.put(A52AudioContainerDescriber.asByte("011000"), 557);
        T_wsf48.put(A52AudioContainerDescriber.asByte("011000"), 512);
        T_wsf32.put(A52AudioContainerDescriber.asByte("011001"), 768);
        T_wsf441.put(A52AudioContainerDescriber.asByte("011001"), 558);
        T_wsf48.put(A52AudioContainerDescriber.asByte("011001"), 512);
        T_wsf32.put(A52AudioContainerDescriber.asByte("011010"), 960);
        T_wsf441.put(A52AudioContainerDescriber.asByte("011010"), 696);
        T_wsf48.put(A52AudioContainerDescriber.asByte("011010"), 640);
        T_wsf32.put(A52AudioContainerDescriber.asByte("011011"), 960);
        T_wsf441.put(A52AudioContainerDescriber.asByte("011011"), 697);
        T_wsf48.put(A52AudioContainerDescriber.asByte("011011"), 640);
        T_wsf32.put(A52AudioContainerDescriber.asByte("011100"), 1152);
        T_wsf441.put(A52AudioContainerDescriber.asByte("011100"), 835);
        T_wsf48.put(A52AudioContainerDescriber.asByte("011100"), 768);
        T_wsf32.put(A52AudioContainerDescriber.asByte("011101"), 1152);
        T_wsf441.put(A52AudioContainerDescriber.asByte("011101"), 836);
        T_wsf48.put(A52AudioContainerDescriber.asByte("011101"), 768);
        T_wsf32.put(A52AudioContainerDescriber.asByte("011110"), 1344);
        T_wsf441.put(A52AudioContainerDescriber.asByte("011110"), 975);
        T_wsf48.put(A52AudioContainerDescriber.asByte("011110"), 896);
        T_wsf32.put(A52AudioContainerDescriber.asByte("011111"), 1344);
        T_wsf441.put(A52AudioContainerDescriber.asByte("011111"), 976);
        T_wsf48.put(A52AudioContainerDescriber.asByte("011111"), 896);
        T_wsf32.put(A52AudioContainerDescriber.asByte("100000"), 1536);
        T_wsf441.put(A52AudioContainerDescriber.asByte("100000"), 1114);
        T_wsf48.put(A52AudioContainerDescriber.asByte("100000"), 1024);
        T_wsf32.put(A52AudioContainerDescriber.asByte("100001"), 1536);
        T_wsf441.put(A52AudioContainerDescriber.asByte("100001"), 1115);
        T_wsf48.put(A52AudioContainerDescriber.asByte("100001"), 1024);
        T_wsf32.put(A52AudioContainerDescriber.asByte("100010"), 1728);
        T_wsf441.put(A52AudioContainerDescriber.asByte("100010"), 1253);
        T_wsf48.put(A52AudioContainerDescriber.asByte("100010"), 1152);
        T_wsf32.put(A52AudioContainerDescriber.asByte("100011"), 1728);
        T_wsf441.put(A52AudioContainerDescriber.asByte("100011"), 1254);
        T_wsf48.put(A52AudioContainerDescriber.asByte("100011"), 1152);
        T_wsf32.put(A52AudioContainerDescriber.asByte("100100"), 1920);
        T_wsf441.put(A52AudioContainerDescriber.asByte("100100"), 1393);
        T_wsf48.put(A52AudioContainerDescriber.asByte("100100"), 1280);
        T_wsf32.put(A52AudioContainerDescriber.asByte("100101"), 1920);
        T_wsf441.put(A52AudioContainerDescriber.asByte("100101"), 1394);
        T_wsf48.put(A52AudioContainerDescriber.asByte("100101"), 1280);
        T_frmsizecod_ws.put(Float.valueOf(32.0f), T_wsf32);
        T_frmsizecod_ws.put(Float.valueOf(44.1f), T_wsf441);
        T_frmsizecod_ws.put(Float.valueOf(48.0f), T_wsf48);
        T_dsurmod.put(A52AudioContainerDescriber.asByte("00"), "not indicated");
        T_dsurmod.put(A52AudioContainerDescriber.asByte("01"), "Not Dolby Surround encoded");
        T_dsurmod.put(A52AudioContainerDescriber.asByte("10"), "Dolby Surround encoded");
        T_dsurmod.put(A52AudioContainerDescriber.asByte("11"), "reserved");
    }
}

