/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.impl.AssertionExplanation;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import com.apple.jingle.leghorn.fileformat.impl.Predicate;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

public class XPathAssertion
extends Predicate {
    private static Logger logger = Logger.getLogger(XPathAssertion.class);
    protected String expression;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean evaluate(Node node, ConformanceResultGatherer gatherer) {
        boolean assertionSuccess;
        block9: {
            XmlObject xmlObj = null;
            try {
                xmlObj = XmlObject.Factory.parse(node);
            }
            catch (XmlException xe) {
                throw new RuntimeException("Conformance assertion error in parsing description xml", xe);
            }
            assertionSuccess = false;
            try {
                String nodeText;
                XmlObject[] selectedNodes = xmlObj.selectPath(this.expression);
                XmlCursor selectedNode = null;
                if (selectedNodes != null && selectedNodes.length > 0) {
                    selectedNode = selectedNodes[0].newCursor();
                }
                assertionSuccess = selectedNode == null ? false : ("true".equals(nodeText = selectedNode.getTextValue()) ? true : !"false".equals(nodeText));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(assertionSuccess + " " + selectedNode + " " + this));
                    if (selectedNode != null) {
                        Node n = selectedNodes[0].getDomNode();
                        XmlCursor cur = selectedNodes[0].newCursor();
                        logger.debug((Object)("name: " + n.getNodeName()));
                        logger.debug((Object)("type: " + n.getNodeType()));
                        logger.debug((Object)("value: " + n.getNodeValue()));
                        logger.debug((Object)("chars: " + cur.getChars()));
                        logger.debug((Object)("text: " + cur.getTextValue()));
                    }
                }
                if (gatherer != null) {
                    gatherer.add(this.createExplanation(xmlObj, assertionSuccess));
                    if (!assertionSuccess && this.errorCode != null) {
                        gatherer.addErrorCode(MediaValidationCode.valueOf(this.errorCode));
                    }
                }
            }
            catch (Exception e) {
                if (gatherer == null) break block9;
                AssertionExplanation ae = new AssertionExplanation(this, assertionSuccess);
                ae.setFormattedExplanation("[Error while testing '" + this.getName() + "']: " + e);
                gatherer.add(ae);
            }
        }
        return assertionSuccess;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("expression", (Object)this.expression).append("explanation", (Object)this.explanation).append("arguments", (Object)this.arguments).append("highlights", (Object)this.highlights).toString();
    }
}

