/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDescriptionDocument;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDiagnostic;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDiagnosticList;
import com.apple.jingle.leghorn.util.XmlBeansHelper;
import org.apache.xmlbeans.XmlTokenSource;
import org.w3.ns.ttml.PEltype;
import org.w3.ns.ttml.RbEltype;
import org.w3.ns.ttml.RtEltype;
import org.w3.ns.ttml.RubyEltype;
import org.w3.ns.ttml.SpanEltype;

public class WellFormedRubyValidator {
    private boolean _isRubyAllowed;
    private boolean _didReportedMissingExtension = false;
    private SubtitleDescriptionDocument.SubtitleDescription _desc;
    private long _rubyTagCount = 0L;

    public long rubyTagCount() {
        return this._rubyTagCount;
    }

    public WellFormedRubyValidator(SubtitleDescriptionDocument.SubtitleDescription desc, boolean isRubyAllowed) {
        this._isRubyAllowed = isRubyAllowed;
        this._desc = desc;
    }

    public void validate(PEltype e) {
        this.checkForRubyHelper(e.getRubyArray());
        for (SpanEltype span : e.getSpanArray()) {
            this.recurseSpanLookingForRuby(span);
        }
        if (!this._isRubyAllowed && this._rubyTagCount != 0L && !this._didReportedMissingExtension) {
            SubtitleDiagnosticList diagList = this._desc.getSubtitleDiagnostics();
            if (diagList == null) {
                diagList = this._desc.addNewSubtitleDiagnostics();
            }
            SubtitleDiagnostic diag = diagList.addNewDiagnostic();
            diag.setCode(MediaValidationCode.ITT_INVALID_RUBY.getCodeNumber());
            diag.setMessage("There is Ruby markup present but there is no declared extension");
            diag.setLocation("1,1");
            this._didReportedMissingExtension = true;
        }
    }

    private void recurseSpanLookingForRuby(SpanEltype span) {
        this.checkForRubyHelper(span.getRubyArray());
        for (SpanEltype s : span.getSpanArray()) {
            this.recurseSpanLookingForRuby(s);
        }
    }

    private void checkForRubyHelper(RubyEltype[] rubies) {
        this._rubyTagCount += (long)rubies.length;
        for (RubyEltype r : rubies) {
            SubtitleDiagnosticList diagList;
            RbEltype rb = r.getRb();
            RtEltype rt = r.getRt();
            if (rb == null || rt == null) {
                diagList = this._desc.getSubtitleDiagnostics();
                if (diagList == null) {
                    diagList = this._desc.addNewSubtitleDiagnostics();
                }
                SubtitleDiagnostic diag = diagList.addNewDiagnostic();
                diag.setCode(MediaValidationCode.ITT_INVALID_RUBY.getCodeNumber());
                diag.setMessage("Invalid Ruby markup");
                diag.setLocation(XmlBeansHelper.fmtLn(XmlBeansHelper.getXmlLineNumber((XmlTokenSource)r)));
                continue;
            }
            String rubyBase = XmlBeansHelper.getText((XmlTokenSource)r.getRb());
            String rubyText = XmlBeansHelper.getText((XmlTokenSource)r.getRt());
            if (!rubyBase.isEmpty() && !rubyText.isEmpty()) continue;
            diagList = this._desc.getSubtitleDiagnostics();
            if (diagList == null) {
                diagList = this._desc.addNewSubtitleDiagnostics();
            }
            SubtitleDiagnostic diag = diagList.addNewDiagnostic();
            diag.setCode(MediaValidationCode.ITT_INVALID_RUBY.getCodeNumber());
            diag.setMessage("Strange Ruby markup, text content is empty");
            diag.setLocation(XmlBeansHelper.fmtLn(XmlBeansHelper.getXmlLineNumber((XmlTokenSource)r)));
        }
    }
}

