/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.ParagraphParser;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.ParagraphParserStrategy;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.TTMLException;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDescriptionDocument;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDiagnostic;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDiagnosticList;
import com.apple.jingle.leghorn.util.XmlBeansHelper;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlTokenSource;
import org.w3.ns.ttml.PEltype;

public class WellFormedRubySpanValidator
implements ParagraphParserStrategy {
    private boolean _isRubyAllowed;
    private boolean _didReportedMissingExtension = false;
    private SubtitleDescriptionDocument.SubtitleDescription _desc;
    private SubtitleDiagnosticList _diagList;
    private long _rubyTagCount = 0L;

    public long rubyTagCount() {
        return this._rubyTagCount;
    }

    public WellFormedRubySpanValidator(SubtitleDescriptionDocument.SubtitleDescription desc, boolean isRubyAllowed) {
        this._isRubyAllowed = isRubyAllowed;
        this._desc = desc;
    }

    public SubtitleDiagnosticList getDiagnosticList() {
        if (this._diagList == null) {
            this._diagList = this._desc.getSubtitleDiagnostics();
            if (this._diagList == null) {
                this._diagList = this._desc.addNewSubtitleDiagnostics();
            }
        }
        return this._diagList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(PEltype[] paragraphs) {
        ParagraphParser parser = ParagraphParser.factory(this);
        for (PEltype p : paragraphs) {
            XmlCursor paraCursor = p.newCursor();
            try {
                parser.processStream(paraCursor);
            }
            catch (TTMLException ex) {
                SubtitleDiagnostic diag = this.getDiagnosticList().addNewDiagnostic();
                diag.setCode(MediaValidationCode.ITT_INVALID_RUBY.getCodeNumber());
                diag.setMessage(ex.getMessage());
                diag.setLocation(XmlBeansHelper.fmtLn(XmlBeansHelper.getXmlLineNumber((XmlTokenSource)p)));
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (paraCursor != null) {
                    paraCursor.dispose();
                }
            }
        }
        if (!this._isRubyAllowed && this._rubyTagCount != 0L && !this._didReportedMissingExtension) {
            SubtitleDiagnosticList diagList = this._desc.getSubtitleDiagnostics();
            if (diagList == null) {
                diagList = this._desc.addNewSubtitleDiagnostics();
            }
            SubtitleDiagnostic diag = diagList.addNewDiagnostic();
            diag.setCode(MediaValidationCode.ITT_INVALID_RUBY.getCodeNumber());
            diag.setMessage("There is Ruby markup present but there is no declared extension");
            diag.setLocation("1,1");
            this._didReportedMissingExtension = true;
        }
    }

    @Override
    public void PushStyle(String styleName) {
    }

    @Override
    public void PopStyle() {
    }

    @Override
    public boolean AppendText(String str) {
        return true;
    }

    @Override
    public void StoreText() {
    }

    @Override
    public void AddBreak() {
    }

    @Override
    public void StoreFullRuby() throws TTMLException {
        ++this._rubyTagCount;
    }

    @Override
    public void StoreRubyBase() throws TTMLException {
    }

    @Override
    public void StoreRubyText() throws TTMLException {
    }

    @Override
    public void StoreRubyAttributes(Map<String, String> attr) throws TTMLException {
    }

    @Override
    public int stringsCount() {
        return 0;
    }
}

