/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.UnknownTypeException;
import com.apple.jingle.leghorn.fileformat.impl.AndPredicate;
import com.apple.jingle.leghorn.fileformat.impl.AssertReference;
import com.apple.jingle.leghorn.fileformat.impl.CompoundAssertion;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceProfile;
import com.apple.jingle.leghorn.fileformat.impl.ContainerTypeFactory;
import com.apple.jingle.leghorn.fileformat.impl.ContainerTypeImpl;
import com.apple.jingle.leghorn.fileformat.impl.ContainerVerifierImpl;
import com.apple.jingle.leghorn.fileformat.impl.DefaultContainerDescriber;
import com.apple.jingle.leghorn.fileformat.impl.JavaAssertionFactory;
import com.apple.jingle.leghorn.fileformat.impl.Locator;
import com.apple.jingle.leghorn.fileformat.impl.MediaConformancePredicate;
import com.apple.jingle.leghorn.fileformat.impl.MediaConformanceProfile;
import com.apple.jingle.leghorn.fileformat.impl.MediaValidationProfile;
import com.apple.jingle.leghorn.fileformat.impl.NotPredicate;
import com.apple.jingle.leghorn.fileformat.impl.OrPredicate;
import com.apple.jingle.leghorn.fileformat.impl.XPathAssertion;
import com.apple.jingle.leghorn.fileformat.matcher.MagicMatcher;
import com.apple.jingle.leghorn.fileformat.matcher.MatcherSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VerifierBuilder {
    private static final String _verifierBaseString = "/com/apple/jingle/leghorn/fileformat/impl/verifier-common.xml,/com/apple/jingle/leghorn/fileformat/impl/verifier-conformance.xml";
    private static final String _leghornVerifierString = "/com/apple/jingle/leghorn/fileformat/impl/verifier-common.xml,/com/apple/jingle/leghorn/fileformat/impl/verifier-conformance.xml,/com/apple/jingle/leghorn/fileformat/impl/productionVerifier.xml";

    public static Verifier buildFoghorn() throws UnableToBuildVerifierException {
        throw new UnableToBuildVerifierException(new Exception("Foghorn describers are EOL from Dec 2014"));
    }

    public static Verifier buildLeghorn() throws UnableToBuildVerifierException {
        try {
            return VerifierBuilder.buildVerifierFromString(_leghornVerifierString);
        }
        catch (Exception e) {
            throw new UnableToBuildVerifierException(e);
        }
    }

    private static Verifier buildVerifierFromString(String xmlListString) throws IOException, SAXException {
        LinkedList<InputStream> verifierXmlStreams = new LinkedList<InputStream>();
        for (String v : xmlListString.split(",")) {
            verifierXmlStreams.add(VerifierBuilder.class.getResourceAsStream(v));
        }
        return VerifierBuilder.buildDigester(verifierXmlStreams);
    }

    public static Verifier buildDefault() throws UnableToBuildVerifierException {
        return VerifierBuilder.buildVerifier(null);
    }

    public static Verifier buildVerifier(String name) throws UnableToBuildVerifierException {
        try {
            String propertyName = name == null ? "com.apple.jingle.leghorn.verifierXml" : "com.apple.jingle.leghorn.verifierXml." + name;
            String verifiersToUse = System.getProperty(propertyName);
            if (StringUtils.isBlank((CharSequence)verifiersToUse)) {
                InputStream propertiesFileStream = VerifierBuilder.class.getResourceAsStream("/foghornleghorn.properties");
                if (propertiesFileStream == null) {
                    throw new IllegalStateException("Could not locate resource \"/foghornleghorn.properties\"; either this file must exist or you must define the system property \"com.apple.jingle.leghorn.verifierXml\" for FoghornLeghorn to function properly.");
                }
                Properties p = new Properties();
                p.load(propertiesFileStream);
                verifiersToUse = p.getProperty(propertyName);
            }
            return VerifierBuilder.buildVerifierFromString(verifiersToUse);
        }
        catch (Exception e) {
            throw new UnableToBuildVerifierException(e);
        }
    }

    public static Verifier buildDigester(List<InputStream> inputStreams) throws IOException, SAXException {
        Verifier verifier = new Verifier();
        final ContainerTypeFactory containerTypeFactory = new ContainerTypeFactory();
        ObjectCreationFactory createContainerTypeFactory = new ObjectCreationFactory(){
            Digester digester;

            @Override
            public Object createObject(Attributes arg0) throws Exception {
                return containerTypeFactory;
            }

            @Override
            public Digester getDigester() {
                return this.digester;
            }

            @Override
            public void setDigester(Digester arg0) {
                this.digester = arg0;
            }
        };
        ObjectCreationFactory createContainerTypeImpl = new ObjectCreationFactory(){
            Digester digester;

            @Override
            public Object createObject(Attributes arg0) throws Exception {
                try {
                    return containerTypeFactory.getTypeForUTI(arg0.getValue("uti"));
                }
                catch (UnknownTypeException e) {
                    return new ContainerTypeImpl();
                }
            }

            @Override
            public Digester getDigester() {
                return this.digester;
            }

            @Override
            public void setDigester(Digester arg0) {
                this.digester = arg0;
            }
        };
        for (InputStream inputStream : inputStreams) {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.push(verifier);
            digester.addSetProperties("verifier");
            digester.addFactoryCreate("verifier/containers", createContainerTypeFactory);
            digester.addSetNext("verifier/containers", "setContainerTypeFactory");
            digester.addFactoryCreate("verifier/containers/container", createContainerTypeImpl);
            digester.addSetNext("verifier/containers/container", "addContainerType");
            digester.addSetProperties("verifier/containers/container");
            digester.addCallMethod("verifier/containers/container", "setUTITypeName", 1);
            digester.addCallParam("verifier/containers/container", 0, "uti");
            digester.addCallMethod("verifier/containers/container", "setName", 1);
            digester.addCallParam("verifier/containers/container", 0, "description");
            digester.addCallMethod("verifier/containers/container", "setCanHaveMultipleStreams", 1);
            digester.addCallParam("verifier/containers/container", 0, "multiplex");
            digester.addCallMethod("verifier/containers/container", "setDescriptionSchemaLocation", 1);
            digester.addCallParam("verifier/containers/container", 0, "description_schema");
            digester.addCallMethod("verifier/containers/container/mime", "setMIMETypeName", 1);
            digester.addCallParam("verifier/containers/container/mime", 0, "type");
            digester.addCallMethod("verifier/containers/container/mime/extension", "addExtension", 0);
            digester.addObjectCreate("verifier/containers/container/verifier", "clazz", ContainerVerifierImpl.class);
            digester.addSetNext("verifier/containers/container/verifier", "setContainerVerifier");
            digester.addSetProperties("verifier/containers/container/verifier");
            digester.addObjectCreate("verifier/containers/container/describer", "clazz", DefaultContainerDescriber.class);
            digester.addSetNext("verifier/containers/container/describer", "setContainerDescriber");
            digester.addSetProperties("verifier/containers/container/describer");
            digester.addObjectCreate("verifier/containers/container/assert_xpath", XPathAssertion.class);
            digester.addSetNext("verifier/containers/container/assert_xpath", "addAssertion");
            digester.addSetProperties("verifier/containers/container/assert_xpath");
            digester.addBeanPropertySetter("verifier/containers/container/assert_xpath/expression");
            digester.addBeanPropertySetter("verifier/containers/container/assert_xpath/explanation");
            digester.addBeanPropertySetter("verifier/containers/container/assert_xpath/error_code", "errorCode");
            digester.addCallMethod("verifier/containers/container/assert_xpath/argument", "addArgument", 0);
            digester.addCallMethod("verifier/containers/container/assert_xpath/highlight", "addHighlight", 0);
            digester.addObjectCreate("verifier/containers/container/assert_xpath/locator", Locator.class);
            digester.addSetNext("verifier/containers/container/assert_xpath/locator", "addLocator");
            digester.addBeanPropertySetter("verifier/containers/container/assert_xpath/locator/base");
            digester.addCallMethod("verifier/containers/container/assert_xpath/locator/stream_id", "setStreamId", 0);
            digester.addBeanPropertySetter("verifier/containers/container/assert_xpath/locator/language");
            digester.addCallMethod("verifier/containers/container/assert_xpath/locator/language_numeric", "setLanguageNumeric", 0);
            digester.addFactoryCreate("verifier/containers/container/assert_java", JavaAssertionFactory.class);
            digester.addSetProperties("verifier/containers/container/assert_java");
            digester.addSetNext("verifier/containers/container/assert_java", "addAssertion");
            digester.addObjectCreate("verifier/containers/container/assert_compound", CompoundAssertion.class);
            digester.addSetProperties("verifier/containers/container/assert_compound");
            digester.addSetNext("verifier/containers/container/assert_compound", "addAssertion");
            digester.addObjectCreate("verifier/containers/container/conformance", ConformanceProfile.class);
            digester.addSetTop("verifier/containers/container/conformance", "setContainerType");
            digester.addSetNext("verifier/containers/container/conformance", "addConformanceProfile");
            digester.addSetProperties("verifier/containers/container/conformance");
            digester.addObjectCreate("verifier/containers/container/mediaverification", MediaValidationProfile.class);
            digester.addSetProperties("verifier/containers/container/mediaverification");
            digester.addSetTop("verifier/containers/container/mediaverification", "setContainerType");
            digester.addSetNext("verifier/containers/container/mediaverification", "addConformanceProfile");
            digester.addObjectCreate("verifier/containers/container/mediaconformance", MediaConformanceProfile.class);
            digester.addSetProperties("verifier/containers/container/mediaconformance");
            digester.addSetTop("verifier/containers/container/mediaconformance", "setContainerType");
            digester.addSetNext("verifier/containers/container/mediaconformance", "addConformanceProfile");
            digester.addObjectCreate("*/assert_mediaconformance", MediaConformancePredicate.class);
            digester.addSetProperties("*/assert_mediaconformance");
            digester.addSetNext("*/assert_mediaconformance", "addChildPredicate");
            digester.addObjectCreate("verifier/containers/container/conformance/blacklist", ConformanceProfile.Blacklist.class);
            digester.addSetNext("verifier/containers/container/conformance/blacklist", "setBlacklist");
            digester.addBeanPropertySetter("verifier/containers/container/conformance/blacklist/code");
            digester.addBeanPropertySetter("verifier/containers/container/conformance/blacklist/explanation");
            digester.addBeanPropertySetter("verifier/containers/container/conformance/blacklist/type");
            digester.addObjectCreate("*/and", AndPredicate.class);
            digester.addSetNext("*/and", "addChildPredicate");
            digester.addObjectCreate("*/or", OrPredicate.class);
            digester.addSetNext("*/or", "addChildPredicate");
            digester.addObjectCreate("*/not", NotPredicate.class);
            digester.addSetNext("*/not", "addChildPredicate");
            digester.addObjectCreate("*/assert_ref", AssertReference.class);
            digester.addSetProperties("*/assert_ref");
            digester.addSetNext("*/assert_ref", "addChildPredicate");
            digester.addObjectCreate("verifier/containers/container/matchers", MatcherSet.class);
            digester.addSetNext("verifier/containers/container/matchers", "setMatcher");
            digester.addFactoryCreate("verifier/containers/container/matchers/match", MagicMatcher.class);
            digester.addCallMethod("verifier/containers/container/matchers/match", "setTypeTest", 2);
            digester.addCallParam("verifier/containers/container/matchers/match", 0, "type");
            digester.addCallParam("verifier/containers/container/matchers/match", 1, "test");
            digester.addSetProperties("verifier/containers/container/matchers/match");
            digester.addFactoryCreate("verifier/containers/container/matchers/match/submatch", MagicMatcher.class);
            digester.addCallMethod("verifier/containers/container/matchers/match/submatch", "setTypeTest", 2);
            digester.addCallParam("verifier/containers/container/matchers/match/submatch", 0, "type");
            digester.addCallParam("verifier/containers/container/matchers/match/submatch", 1, "test");
            digester.addSetProperties("verifier/containers/container/matchers/match/submatch");
            digester.parse(inputStream);
        }
        return verifier;
    }

    public static class UnableToBuildVerifierException
    extends Exception {
        private static final long serialVersionUID = 3741836698701018147L;
        private Throwable rootCause;

        public UnableToBuildVerifierException(Throwable rootCause) {
            this.rootCause = rootCause;
        }

        @Override
        public Throwable getCause() {
            return this.rootCause;
        }

        @Override
        public String getMessage() {
            return "Internal error encountered constructing verifier";
        }
    }
}

