/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationInfo;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.ValidationWarning;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class ValidationsCollector
implements ValidationListener {
    List<ValidationInfo> validationInfos = Lists.newArrayList();

    @Override
    public void error(ValidationError error) {
        this.validationInfos.add(error);
    }

    @Override
    public void info(ValidationInfo info) {
        this.validationInfos.add(info);
    }

    @Override
    public void warning(ValidationWarning warning) {
        this.validationInfos.add(warning);
    }

    public List<ValidationInfo> getValidations() {
        return this.validationInfos;
    }

    public List<ValidationError> getValidationErrors() {
        ArrayList errors = Lists.newArrayList();
        for (ValidationInfo info : this.getValidations()) {
            if (!(info instanceof ValidationError)) continue;
            errors.add((ValidationError)info);
        }
        return errors;
    }

    public void copyToListener(ValidationListener target) {
        for (ValidationInfo o : this.getValidations()) {
            if (o instanceof ValidationError) {
                target.error((ValidationError)o);
                continue;
            }
            if (o instanceof ValidationWarning) {
                target.warning((ValidationWarning)o);
                continue;
            }
            target.info(o);
        }
    }
}

