/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.impl.AssertionExplanation;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import com.apple.jingle.leghorn.fileformat.impl.Surround51AnyOrderPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Node;

public class Surround71AnyOrderPredicate
extends Surround51AnyOrderPredicate {
    private static final List<String> SURROUND_71_LABELS = Arrays.asList("Rls", "Rrs");
    private static final List<String> SURROUND_71_LABELS_ALT = Arrays.asList("Lrs", "Rrs");

    @Override
    public boolean evaluate(Node node, ConformanceResultGatherer gatherer) {
        boolean result = false;
        List<List<String>> trackLayout = this.populatTrackLayout(node);
        if (trackLayout.size() == 8) {
            ArrayList<String> allChannels = new ArrayList<String>();
            for (List<String> chans : trackLayout) {
                if (chans.size() != 1) continue;
                allChannels.add(chans.get(0));
            }
            if (this.equalsAnyOrder(allChannels, this.listUnion(BASE_SURROUND_CHANNEL_LABELS, SURROUND_71_LABELS))) {
                result = true;
            } else if (this.equalsAnyOrder(allChannels, this.listUnion(BASE_SURROUND_CHANNEL_LABELS, SURROUND_71_LABELS_ALT))) {
                result = true;
            }
        }
        if (!result && gatherer != null) {
            AssertionExplanation ae = new AssertionExplanation(this, result);
            ae.setFormattedExplanation("Invalid surround layout: " + trackLayout);
            gatherer.add(ae);
        }
        return result;
    }
}

