/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.impl.AssertionExplanation;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import com.apple.jingle.leghorn.fileformat.impl.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

public class Surround51AnyOrderPredicate
extends Predicate {
    private static final Logger logger = Logger.getLogger(Surround51AnyOrderPredicate.class);
    protected static final List<String> BASE_SURROUND_CHANNEL_LABELS = Arrays.asList("L", "R", "C", "LFE", "Ls", "Rs");
    protected static final List<String> MATRIX_STEREO_LABELS = Arrays.asList("Lt", "Rt");

    @Override
    public boolean evaluate(Node node, ConformanceResultGatherer gatherer) {
        boolean result = false;
        List<List<String>> trackLayout = this.populatTrackLayout(node);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TrackLayout: " + trackLayout));
        }
        if (trackLayout.size() == 2) {
            if (this.equalsAnyOrder(trackLayout.get(0), BASE_SURROUND_CHANNEL_LABELS) || this.equalsAnyOrder(trackLayout.get(1), BASE_SURROUND_CHANNEL_LABELS)) {
                result = true;
            }
        } else if (trackLayout.size() == 3) {
            if (this.equalsAnyOrder(trackLayout.get(0), BASE_SURROUND_CHANNEL_LABELS)) {
                result = true;
            }
        } else if (trackLayout.size() == 7) {
            List<String> firstSix = this.getChannelLabels(trackLayout, 0, 6);
            if (this.equalsAnyOrder(firstSix, BASE_SURROUND_CHANNEL_LABELS)) {
                result = true;
            } else {
                List<String> lastSix = this.getChannelLabels(trackLayout, 1, 7);
                if (this.equalsAnyOrder(lastSix, BASE_SURROUND_CHANNEL_LABELS)) {
                    result = true;
                }
            }
        } else if (trackLayout.size() == 8) {
            ArrayList<String> allChannels = new ArrayList<String>();
            for (List<String> chans : trackLayout) {
                if (chans.size() != 1) continue;
                allChannels.add(chans.get(0));
            }
            if (this.equalsAnyOrder(allChannels, this.listUnion(BASE_SURROUND_CHANNEL_LABELS, MATRIX_STEREO_LABELS))) {
                result = true;
            }
        }
        if (!result && gatherer != null) {
            AssertionExplanation ae = new AssertionExplanation(this, result);
            ae.setFormattedExplanation("Invalid surround layout: " + trackLayout);
            gatherer.add(ae);
        }
        return result;
    }

    protected List<List<String>> populatTrackLayout(Node node) {
        XmlObject baseObject;
        ArrayList<List<String>> trackLayout = new ArrayList<List<String>>();
        try {
            baseObject = XmlObject.Factory.parse(node);
        }
        catch (XmlException xe) {
            throw new IllegalArgumentException("Can't convert node into an XmlObject", xe);
        }
        for (XmlObject soundTrack : baseObject.selectPath("/movie/tracks/sound")) {
            XmlObject[] channelObjs;
            Long id = ((SimpleValue)soundTrack.selectPath("./track_id")[0]).getLongValue();
            ArrayList<String> channels = new ArrayList<String>();
            for (XmlObject chan : channelObjs = soundTrack.selectPath("./channel_layout/channel")) {
                channels.add(((SimpleValue)chan).getStringValue());
            }
            trackLayout.add(channels);
        }
        return trackLayout;
    }

    protected boolean equalsAnyOrder(List<String> l1, List<String> l2) {
        HashSet<String> s1 = new HashSet<String>(l1);
        HashSet<String> s2 = new HashSet<String>(l2);
        return s1.equals(s2);
    }

    private List<String> getChannelLabels(List<List<String>> tracks, int startIdx, int endIndex) {
        ArrayList<String> allChannels = new ArrayList<String>();
        for (int i = startIdx; i < endIndex; ++i) {
            List<String> chans = tracks.get(i);
            if (chans.size() != 1) continue;
            allChannels.add(chans.get(0));
        }
        return allChannels;
    }

    protected <T> List<T> listUnion(List<T> L1, List<T> L2) {
        ArrayList<T> ret = new ArrayList<T>(L1);
        ret.addAll(L2);
        return ret;
    }
}

