/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.FormatDescription;
import com.apple.jingle.leghorn.fileformat.impl.SimpleContainerDescription;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.w3c.dom.Node;

public class SlightlyMoreAdvancedContainerDescription
extends SimpleContainerDescription {
    private List<String> streamIdentifiers;
    private Map<String, FormatDescription<Node>> formatDescriptions;

    public SlightlyMoreAdvancedContainerDescription(Node descriptionDocument, ContainerType containerType, String selectStreams, String selectIdFromStream, FormatDescriptionGenerator formatDescriptionGenerator) throws XmlException {
        this.setDescriptionDocument(descriptionDocument);
        this.setType(containerType);
        XmlObject o = XmlObject.Factory.parse(descriptionDocument);
        XmlObject[] streams = o.selectPath(selectStreams);
        this.streamIdentifiers = new LinkedList<String>();
        this.formatDescriptions = new HashMap<String, FormatDescription<Node>>();
        for (XmlObject stream : streams) {
            XmlObject[] idArray = stream.selectPath(selectIdFromStream);
            if (idArray.length != 1) {
                throw new RuntimeException("Running xpath \"" + selectIdFromStream + "\" on node \"" + stream.toString() + "\" did not return a single stream ID, but instead returned " + idArray.length + " elements: " + idArray);
            }
            String streamId = XmlString.Factory.parse(idArray[0].getDomNode()).getStringValue();
            FormatDescription<Node> formatDescription = formatDescriptionGenerator.getFormatDescriptionFromStream(stream, o);
            this.streamIdentifiers.add(streamId);
            this.formatDescriptions.put(streamId, formatDescription);
        }
    }

    @Override
    public FormatDescription<Node> getStreamFormatDescription(String streamId) {
        return this.formatDescriptions.get(streamId);
    }

    @Override
    public List<String> getStreamIdentifiers() {
        return this.streamIdentifiers;
    }

    @Override
    public boolean hasMultipleStreams() {
        return this.streamIdentifiers.size() > 1;
    }

    @Override
    public void setHasMultipleStreams(boolean hasMultipleStreams) {
        throw new RuntimeException("Cannot call setHasMultipleStreams on this object");
    }

    @Override
    public void setStreamIdentifiers(List<String> streamIdentifiers) {
        throw new RuntimeException("Cannot call setStreamIdentifiers on this object");
    }

    public static interface FormatDescriptionGenerator {
        public FormatDescription<Node> getFormatDescriptionFromStream(XmlObject var1, XmlObject var2);
    }
}

