/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.FormatDescription;
import com.apple.jingle.leghorn.fileformat.FormatType;
import com.apple.jingle.leghorn.fileformat.impl.SimpleContainerDescription;
import com.apple.jingle.locale.LocaleCode;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;

public class SingleStreamContainerDescription
extends SimpleContainerDescription {
    private String streamTypeName;
    private LocaleCode streamLanguage;

    public SingleStreamContainerDescription(Node descriptionDocument, String streamTypeName, LocaleCode streamLanguage, ContainerType type) {
        this.setDescriptionDocument(descriptionDocument);
        this.setType(type);
        this.streamTypeName = streamTypeName;
        this.streamLanguage = streamLanguage;
    }

    @Override
    public FormatDescription<Node> getStreamFormatDescription(final String streamId) {
        return new FormatDescription<Node>(){

            @Override
            public Node getDescriptionNode() {
                return SingleStreamContainerDescription.this.getDescriptionDocument();
            }

            @Override
            public LocaleCode getLanguage() {
                return SingleStreamContainerDescription.this.streamLanguage;
            }

            @Override
            public FormatType getType() {
                return new FormatType(){

                    @Override
                    public String getName() {
                        return SingleStreamContainerDescription.this.streamTypeName;
                    }
                };
            }

            @Override
            public String getPresentableDescription() {
                return "Stream " + streamId;
            }
        };
    }

    @Override
    public List<String> getStreamIdentifiers() {
        return Collections.singletonList("0");
    }

    @Override
    public boolean hasMultipleStreams() {
        return false;
    }

    @Override
    public boolean isHasMultipleStreams() {
        return false;
    }

    @Override
    public void setHasMultipleStreams(boolean hasMultipleStreams) {
        throw new IllegalStateException("Cannot call setHasMultipleStreams on a SingleStreamContainerDescription");
    }

    @Override
    public void setStreamIdentifiers(List<String> streamIdentifiers) {
        throw new IllegalStateException("Cannot call setStreamIdentifiers on a SingleStreamContainerDescription");
    }
}

