/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.impl.AssertReference;
import com.apple.jingle.leghorn.fileformat.impl.AssertionExplanation;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import com.apple.jingle.leghorn.fileformat.impl.Locator;
import com.apple.jingle.leghorn.fileformat.impl.StreamLocation;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

public abstract class Predicate {
    protected String name;
    protected List<Predicate> childPredicates = new ArrayList<Predicate>();
    protected String explanation;
    protected String errorCode;
    protected List<String> arguments = new ArrayList<String>();
    protected List<String> highlights = new ArrayList<String>();
    protected List<Locator> locators = new ArrayList<Locator>();

    public List<Locator> getLocators() {
        return this.locators;
    }

    public void addLocator(Locator locator) {
        this.locators.add(locator);
    }

    public List<String> getHighlights() {
        return this.highlights;
    }

    public void addHighlight(String highlight) {
        this.highlights.add(highlight);
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void addArgument(String arg) {
        this.arguments.add(arg);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String code) {
        this.errorCode = code;
    }

    public List<Predicate> getChildPredicates() {
        return this.childPredicates;
    }

    public void addChildPredicate(Predicate pred) {
        this.childPredicates.add(pred);
    }

    protected AssertionExplanation createExplanation(XmlObject node, boolean success) {
        AssertionExplanation reason = new AssertionExplanation(this, success);
        if (success) {
            ArrayList<StreamLocation> locations = new ArrayList<StreamLocation>();
            for (Locator loc : this.locators) {
                locations.addAll(loc.lookupLocation(node));
            }
            reason.setLocations(locations);
        }
        this.fillFormattedExplanation(node, reason);
        return reason;
    }

    private void fillFormattedExplanation(XmlObject node, AssertionExplanation reason) {
        ArrayList<String> argumentValues = new ArrayList<String>();
        for (String arg : this.arguments) {
            XmlObject[] selectedNodes = node.selectPath(arg);
            if (selectedNodes != null && selectedNodes.length > 0) {
                XmlCursor cur = selectedNodes[0].newCursor();
                argumentValues.add(cur.getTextValue());
                continue;
            }
            argumentValues.add(null);
        }
        if (this.explanation != null) {
            try {
                reason.setFormattedExplanation(String.format(this.explanation, argumentValues.toArray()));
            }
            catch (IllegalFormatException ife) {
                reason.setFormattedExplanation(ife.toString());
            }
        } else {
            reason.setFormattedExplanation(this.name + ": No explanation available");
        }
    }

    public void resolveReferences(ContainerType container) {
        Map<String, Predicate> assertions = container.getAssertions();
        for (int i = 0; i < this.childPredicates.size(); ++i) {
            Predicate p = this.childPredicates.get(i);
            String name = p.getName();
            if (p instanceof AssertReference) {
                Predicate actual = assertions.get(name);
                if (actual == null) {
                    throw new RuntimeException("Bad xml! Assert-Ref not found: " + name);
                }
                this.childPredicates.set(i, actual);
            }
            this.childPredicates.get(i).resolveReferences(container);
        }
    }

    public abstract boolean evaluate(Node var1, ConformanceResultGatherer var2);

    public String toString() {
        return new ToStringBuilder((Object)this).append("childPredicates", this.childPredicates).toString();
    }
}

