/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import com.apple.jingle.leghorn.media.MediaFactory;
import com.apple.jingle.leghorn.media.MediaProperties;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaFileMetaDataImpl;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.media.validator.ValidationResultSet;
import com.apple.jingle.leghorn.media.validator.conformance.AudioConformanceChecks;
import com.apple.jingle.leghorn.media.validator.conformance.Feature51Verification;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class MediaValidationChecker {
    private static final Logger logger = Logger.getLogger(MediaValidationChecker.class);
    public static final Feature51Verification checks = new Feature51Verification();
    @Nonnull
    private final String name;
    @Nonnull
    private final UniformTypeIdentifier uti;

    public MediaValidationChecker(@Nonnull ContainerType containerType, @Nonnull String name) {
        this.name = name;
        this.uti = UniformTypeIdentifier.findByIdentifier((String)containerType.getUTITypeName());
    }

    public String getName() {
        return this.name;
    }

    public final boolean testNode(@Nonnull Node node, @Nullable ConformanceResultGatherer gatherer) {
        if (null == gatherer) {
            gatherer = new ConformanceResultGatherer();
        }
        try {
            MediaFileMetaDataImpl metaData = new MediaFileMetaDataImpl("XmlFragement", this.uti, new ValidationResultSet(), MediaProperties.nullProperties, Collections.emptyMap(), null, "unknown", "unknown");
            if (node.getOwnerDocument() != null) {
                node = node.getOwnerDocument();
            }
            if (node.getOwnerDocument() != null) {
                node = node.getOwnerDocument();
            }
            MediaFile mediaFile = MediaFactory.newMediaFile((MediaFileContext)metaData, node);
            return this.testNode(mediaFile, gatherer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean testNode(@Nonnull MediaFile mediaFile, @Nullable ConformanceResultGatherer gatherer) {
        if (null == gatherer) {
            gatherer = new ConformanceResultGatherer();
        }
        int beforeCount = gatherer.getValidationResults().getValidations(ValidationLevel.ERROR).size();
        checks.validate(mediaFile, gatherer.getValidationResults(), this.getName());
        new AudioConformanceChecks(mediaFile).validate(mediaFile, gatherer.getValidationResults(), this.getName());
        int afterCount = gatherer.getValidationResults().getValidations(ValidationLevel.ERROR).size();
        int idx = 0;
        for (ValidationResult vr : gatherer.getValidationResults().getValidations()) {
            if (idx++ < beforeCount) continue;
            String message = vr.getValidationLevel().name() + "[" + vr.getValidationCode() + "]" + "@" + vr.getValidatedResourceId() + ": " + vr.getValidationMessage();
            logger.info((Object)message);
        }
        return afterCount == beforeCount;
    }
}

