/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerDescriber;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public interface InputStreamContainerDescriber<T>
extends ContainerDescriber<T> {
    public ContainerDescription<T> describe(BufferedInputStream var1, ContainerType var2) throws IOException, DescriptionException;

    public static abstract class Util {
        public static final int BUFFERED_INPUT_STREAM_DEFAULT_SIZE = 8192;

        protected static <T> ContainerDescription<T> describe(InputStreamContainerDescriber<T> inputStreamContainerDescriber, URI uri, ContainerType type) throws IOException, DescriptionException {
            return Util.describe(inputStreamContainerDescriber, type, new FileInputStream(new File(uri)));
        }

        protected static <T> ContainerDescription<T> describe(InputStreamContainerDescriber<T> inputStreamContainerDescriber, Verifier.Describable describable, ContainerType type) throws IOException, DescriptionException {
            return Util.describe(inputStreamContainerDescriber, type, describable.getInputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <T> ContainerDescription<T> describe(InputStreamContainerDescriber<T> inputStreamContainerDescriber, ContainerType type, InputStream inputStream) throws IOException, DescriptionException {
            try (BufferedInputStream bis = new BufferedInputStream(inputStream, 8192);){
                ContainerDescription<T> containerDescription = inputStreamContainerDescriber.describe(bis, type);
                return containerDescription;
            }
        }
    }
}

