/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.impl.AssertionExplanation;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import com.apple.jingle.leghorn.fileformat.impl.Predicate;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

public class HDAudioTracksMatchSampleRatePredicate
extends Predicate {
    @Override
    public boolean evaluate(Node node, ConformanceResultGatherer gatherer) {
        XmlObject baseObject;
        boolean result = true;
        HashMap<Long, Long> sampleRateMap = new HashMap<Long, Long>();
        HashMap<Long, Long> pairedTrackMap = new HashMap<Long, Long>();
        try {
            baseObject = XmlObject.Factory.parse(node);
        }
        catch (XmlException xe) {
            throw new RuntimeException("Can't convert node into an XmlObject", xe);
        }
        for (XmlObject soundTrack : baseObject.selectPath("/movie/tracks/sound")) {
            Long id = ((SimpleValue)soundTrack.selectPath("./track_id")[0]).getLongValue();
            Long sampleRate = Math.round(((SimpleValue)soundTrack.selectPath("./sample_rate")[0]).getDoubleValue() * 1000.0);
            sampleRateMap.put(id, sampleRate);
            for (XmlObject fallRef : soundTrack.selectPath("./track_reference[@type='fall']")) {
                Long otherId = ((SimpleValue)fallRef).getLongValue();
                pairedTrackMap.put(id, otherId);
            }
        }
        for (Map.Entry e : pairedTrackMap.entrySet()) {
            Long srB;
            Long a = (Long)e.getKey();
            Long b = (Long)e.getValue();
            Long srA = (Long)sampleRateMap.get(a);
            if (srA.equals(srB = (Long)sampleRateMap.get(b))) continue;
            AssertionExplanation ae = new AssertionExplanation(this, false);
            ae.setFormattedExplanation(String.format("Tracks attached by a 'fall' atom must have the sample sample rate: track #%d = %dhz while track #%d = %dhz", a, srA, b, srB));
            if (gatherer != null) {
                gatherer.add(ae);
            }
            result = false;
        }
        return result;
    }
}

