/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DescriptionDocumentUtilities {
    public static Document constructBasicDescription(String rootNodeName, long size, String version) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Comment comment = document.createComment("Generated by the FoghornLeghorn, version " + version);
            document.appendChild(comment);
            Element rootNode = document.createElement(rootNodeName);
            rootNode.setAttribute("fileSize", Long.toString(size));
            document.appendChild(rootNode);
            return document;
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("ParserConfigurationException caught", pce);
        }
    }

    public static Document addDescriptionAttribute(Document document, String rootNodeName, String name, String value) {
        return DescriptionDocumentUtilities.addDescriptionAttributeAtIndex(document, rootNodeName, name, value, 0);
    }

    public static Document addDescriptionAttributeAtIndex(Document document, String rootNodeName, String name, String value, int index) {
        Element newNode = document.createElement(name);
        Text newNode2 = document.createTextNode(value);
        Node rootNode = document.getElementsByTagName(rootNodeName).item(index);
        rootNode.appendChild(newNode);
        newNode.appendChild(newNode2);
        return document;
    }

    public static Document addDescriptionWithAttribute(Document document, String rootNodeName, String name, String value, Map<String, String> attributes) {
        return DescriptionDocumentUtilities.addDescriptionWithAttributeAtIndex(document, rootNodeName, name, value, attributes, 0);
    }

    public static Document addDescriptionWithAttributeAtIndex(Document document, String rootNodeName, String name, String value, Map<String, String> attributes, int index) {
        Element newNode = document.createElement(name);
        for (Map.Entry<String, String> attr : attributes.entrySet()) {
            newNode.setAttribute(attr.getKey(), attr.getValue());
        }
        Text newNode2 = document.createTextNode(value);
        Node rootNode = document.getElementsByTagName(rootNodeName).item(index);
        rootNode.appendChild(newNode);
        newNode.appendChild(newNode2);
        return document;
    }

    public static Document addDescriptionAttribute(Document document, String rootNodeName, String name, Object value) {
        return DescriptionDocumentUtilities.addDescriptionAttribute(document, rootNodeName, name, value != null ? value.toString() : null);
    }
}

