/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceProfile;
import com.apple.jingle.leghorn.fileformat.impl.ContainerDescriber;
import com.apple.jingle.leghorn.fileformat.impl.ContainerVerifier;
import com.apple.jingle.leghorn.fileformat.impl.Predicate;
import com.apple.jingle.leghorn.fileformat.matcher.Matcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ContainerTypeImpl
implements ContainerType {
    protected String name;
    protected String UTITypeName;
    protected String MIMETypeName;
    protected ContainerVerifier containerVerifier;
    protected ContainerDescriber<?> containerDescriber;
    protected boolean canHaveMultipleStreams;
    protected List<String> validExtensions = Lists.newArrayList();
    protected Matcher matcher = null;
    protected Map<String, ConformanceProfile> conformanceProfiles = Maps.newHashMap();
    protected Map<String, Predicate> assertions = Maps.newHashMap();
    private String descriptionSchemaLocation;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getUTITypeName() {
        return this.UTITypeName;
    }

    public void setUTITypeName(String UTITypeName) {
        this.UTITypeName = UTITypeName;
    }

    @Override
    public String getMIMETypeName() {
        return this.MIMETypeName;
    }

    public void setMIMETypeName(String MIMETypeName) {
        this.MIMETypeName = MIMETypeName;
    }

    @Override
    public boolean canHaveMultipleStreams() {
        return this.canHaveMultipleStreams;
    }

    public void setCanHaveMultipleStreams(String canHaveMultipleStreams) {
        this.canHaveMultipleStreams = canHaveMultipleStreams.equals("true");
    }

    @Override
    public List<String> getValidExtensions() {
        return this.validExtensions;
    }

    @Override
    public ContainerVerifier getContainerVerifier() {
        return this.containerVerifier;
    }

    public void setContainerVerifier(ContainerVerifier containerVerifier) {
        this.containerVerifier = containerVerifier;
    }

    @Override
    public ContainerDescriber<?> getContainerDescriber() {
        return this.containerDescriber;
    }

    public void setContainerDescriber(ContainerDescriber<?> containerDescriber) {
        this.containerDescriber = containerDescriber;
    }

    public void addExtension(String extension) {
        this.validExtensions.add(extension);
    }

    @Override
    public Set<String> getConformanceProfileNames() {
        return this.conformanceProfiles.keySet();
    }

    @Override
    public ConformanceProfile getConformanceProfile(String profileName) {
        return this.conformanceProfiles.get(profileName);
    }

    public void addConformanceProfile(ConformanceProfile conformanceProfile) {
        this.conformanceProfiles.put(conformanceProfile.getName(), conformanceProfile);
    }

    @Override
    public Matcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerTypeImpl that = (ContainerTypeImpl)o;
        return this.name == null ? that.name == null : this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("UTITypeName", (Object)this.UTITypeName).append("MIMETypeName", (Object)this.MIMETypeName).append("extensions", this.validExtensions).append("conformanceProfiles", this.conformanceProfiles.keySet()).append("canHaveMultipleStreams", this.canHaveMultipleStreams).toString();
    }

    private void setDescriptionSchemaLocation(String descriptionSchemaLocation) {
        this.descriptionSchemaLocation = descriptionSchemaLocation;
    }

    @Override
    public Map<String, Predicate> getAssertions() {
        return this.assertions;
    }

    @Override
    public void addAssertion(Predicate assertion) {
        if (this.assertions.containsKey(assertion.getName())) {
            throw new IllegalArgumentException(String.format("Bad xml! Two Assertions with the same name: %s %s", assertion, this.assertions.get(assertion.getName())));
        }
        this.assertions.put(assertion.getName(), assertion);
    }
}

