/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriberNotFoundException;
import com.apple.jingle.leghorn.fileformat.exceptions.UnknownTypeException;
import com.apple.jingle.leghorn.fileformat.exceptions.VerifierNotFoundException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerDescriber;
import com.apple.jingle.leghorn.fileformat.impl.ContainerVerifier;
import com.apple.jingle.leghorn.fileformat.matcher.MagicMatcherSet;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class ContainerTypeFactory {
    private final Set<ContainerType> containerTypes = Sets.newHashSet();
    private final Map<String, ContainerType> containerTypesByUTI = Maps.newHashMap();
    private final Map<String, ContainerType> containerTypesByMIME = Maps.newHashMap();
    private final Map<String, ContainerType> containerExtensions = Maps.newHashMap();
    private final Collection<ContainerType> magicMatchers = Sets.newHashSet();
    private static final CharMatcher DOT_MATCHER = CharMatcher.anyOf((CharSequence)". ");

    private ContainerType typeWithCaseInsenstiveKeyFromCache(String key, Map<String, ContainerType> cache) throws UnknownTypeException {
        String lowercaseTrimmedKey = key.trim().toLowerCase();
        if (!cache.containsKey(lowercaseTrimmedKey)) {
            throw new UnknownTypeException(lowercaseTrimmedKey);
        }
        return cache.get(lowercaseTrimmedKey);
    }

    public ContainerType getTypeForMimeType(String mimeType) throws UnknownTypeException {
        ContainerType foundContainerType = null;
        try {
            foundContainerType = this.typeWithCaseInsenstiveKeyFromCache(mimeType, this.containerTypesByMIME);
        }
        catch (UnknownTypeException e) {
            try {
                String standardMimeType = mimeType.replace("/x-", "/");
                foundContainerType = this.typeWithCaseInsenstiveKeyFromCache(standardMimeType, this.containerTypesByMIME);
            }
            catch (UnknownTypeException f) {
                throw e;
            }
        }
        return foundContainerType;
    }

    public ContainerType getTypeForUTI(String uti) throws UnknownTypeException {
        return this.typeWithCaseInsenstiveKeyFromCache(uti, this.containerTypesByUTI);
    }

    public ContainerType getTypeForExtension(String extension) throws UnknownTypeException {
        String trimmedExtension = DOT_MATCHER.trimLeadingFrom((CharSequence)extension);
        String key = StringUtils.isNotBlank((CharSequence)trimmedExtension) ? trimmedExtension : "?";
        return this.typeWithCaseInsenstiveKeyFromCache(key, this.containerExtensions);
    }

    public ContainerType getTypeForFile(File toDescribe) throws UnknownTypeException {
        return this.getTypeForExtension(FilenameUtils.getExtension((String)toDescribe.getName()));
    }

    public ContainerVerifier getVerifierForType(ContainerType type) throws VerifierNotFoundException {
        return type.getContainerVerifier();
    }

    public ContainerDescriber<?> getDescriberForType(ContainerType type) throws DescriberNotFoundException {
        return type.getContainerDescriber();
    }

    public void addContainerType(ContainerType type) {
        this.containerTypes.add(type);
        this.containerTypesByUTI.put(StringUtils.lowerCase((String)type.getUTITypeName()), type);
        this.containerTypesByMIME.put(StringUtils.lowerCase((String)type.getMIMETypeName()), type);
        if (type.getMatcher() instanceof MagicMatcherSet) {
            this.magicMatchers.add(type);
        }
        for (String extension : type.getValidExtensions()) {
            this.containerExtensions.put(DOT_MATCHER.trimLeadingFrom((CharSequence)extension).toLowerCase(), type);
        }
    }

    public Set<ContainerType> getAllContainerTypes() {
        return this.containerTypes;
    }

    public ContainerType guessContainerType(File file) throws IOException {
        return (ContainerType)Iterables.getFirst(this.getContainerTypes(file), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ContainerType> getContainerTypes(File file) throws IOException {
        LinkedList typeCandidates = Lists.newLinkedList(this.magicMatchers);
        ArrayList typeMatches = Lists.newArrayList();
        long fileLength = file.length();
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            for (long position = 0L; !typeCandidates.isEmpty() && position < fileLength; ++position) {
                byte b = (byte)((InputStream)is).read();
                Iterator iter = typeCandidates.iterator();
                while (iter.hasNext()) {
                    ContainerType currContainerType = (ContainerType)iter.next();
                    MagicMatcherSet mms = (MagicMatcherSet)((Object)currContainerType.getMatcher());
                    if (!mms.matches(b, position)) {
                        iter.remove();
                        Logger.getAnonymousLogger().info("Eliminated: " + currContainerType.getUTITypeName() + " ... remaining " + typeCandidates);
                        continue;
                    }
                    if (position <= mms.getOffset() + (long)mms.getBytesNeeded()) continue;
                    typeMatches.add(currContainerType);
                    iter.remove();
                }
            }
        }
        return typeMatches;
    }
}

