/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.UniformTypeIdentiferContainerTypeAdaptor;
import com.apple.jingle.leghorn.fileformat.impl.ContainerDescriber;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import com.apple.jingle.media.foundation.util.XMLUtil;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Node;

public abstract class ContainerContainerDescriberRunner {
    public static <T extends Node> void main(@Nonnull ContainerDescriber<T> describer, @Nullable UniformTypeIdentifier uti, @Nonnull String[] args) throws Exception {
        if (args.length != 1) {
            ContainerContainerDescriberRunner.usage(System.out);
        } else {
            URI uri = ContainerContainerDescriberRunner.uriForString(args[0], true);
            ContainerDescription<T> description = describer.describe(uri, (ContainerType)(uti != null ? new UniformTypeIdentiferContainerTypeAdaptor(uti) : null));
            ContainerContainerDescriberRunner.prettyPrint((Node)description.getDescriptionDocument(), System.out);
        }
    }

    public static void usage(PrintStream printStream) {
        printStream.println("requires <filename> param");
    }

    public static void prettyPrint(Node xml, OutputStream out) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, Charsets.UTF_8);
        XMLUtil.serializeNode((Node)xml, (int)2, (Writer)writer, (boolean)true);
        writer.flush();
    }

    public static URI uriForString(String fileArgument, boolean useAssetPool) throws URISyntaxException {
        URI uri;
        if (fileArgument.startsWith("http://") || fileArgument.startsWith("file://")) {
            uri = new URI(fileArgument);
        } else {
            String argumentToUse;
            if (fileArgument.startsWith("/")) {
                argumentToUse = fileArgument;
            } else {
                String extra = useAssetPool ? "/jingle/AssetPool/" : "/";
                argumentToUse = "/" + System.getProperty("user.home") + extra + fileArgument;
            }
            uri = new File(argumentToUse).toURI();
        }
        return uri;
    }

    public static URI uriForString(String fileArgument) throws URISyntaxException {
        return ContainerContainerDescriberRunner.uriForString(fileArgument, false);
    }
}

