/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ValidationInfo;
import com.apple.jingle.leghorn.fileformat.impl.AssertionExplanation;
import com.apple.jingle.leghorn.fileformat.impl.Predicate;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationLevelCalculator;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.media.validator.ValidationResultSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConformanceResultGatherer {
    private List<AssertionExplanation> successes = new LinkedList<AssertionExplanation>();
    private List<AssertionExplanation> failures = new LinkedList<AssertionExplanation>();
    private List<MediaValidationCode> errorCodes = new LinkedList<MediaValidationCode>();
    @Nonnull
    private final ValidationResultSet validationResults;

    public ConformanceResultGatherer() {
        this.validationResults = new ValidationResultSet();
    }

    public ConformanceResultGatherer(@Nonnull ValidationLevelCalculator levelCalc) {
        this.validationResults = new ValidationResultSet(levelCalc);
    }

    public MediaValidationCode getErrorCode() {
        return this.errorCodes.size() > 0 ? this.errorCodes.get(0) : null;
    }

    public List<MediaValidationCode> getErrorCodes() {
        return this.errorCodes;
    }

    @Nonnull
    public ValidationResultSet getValidationResults() {
        return this.validationResults;
    }

    public List<ValidationInfo> getValidationErrors() {
        ArrayList<ValidationInfo> validationErrors = new ArrayList<ValidationInfo>();
        for (int i = 0; i < this.errorCodes.size(); ++i) {
            validationErrors.add(new ValidationInfo(this.failures.get(i).getFormattedExplanation(), this.errorCodes.get(i)));
        }
        return validationErrors;
    }

    public List<AssertionExplanation> getSuccesses() {
        return this.successes;
    }

    public List<AssertionExplanation> getFailures() {
        return this.failures;
    }

    public void add(AssertionExplanation result) {
        if (result.getSuccess()) {
            this.successes.add(result);
        } else {
            this.failures.add(result);
        }
    }

    public void addAll(@Nonnull ValidationResultSet results) {
        for (ValidationResult result : results.getValidations()) {
            this.add(null, result);
        }
    }

    @Nonnull
    public AssertionExplanation add(@Nullable Predicate predicate, @Nonnull ValidationResult result) {
        AssertionExplanation explanation;
        ValidationLevel level = result.getValidationLevel();
        if (level.asSevereAs(ValidationLevel.ERROR)) {
            explanation = new AssertionExplanation(predicate, false);
            explanation.setFormattedExplanation(result.getValidationMessage());
            this.failures.add(explanation);
            this.errorCodes.add(result.getRegisteredValidationCode());
        } else {
            explanation = new AssertionExplanation(null, true);
            explanation.setFormattedExplanation(result.getValidationMessage());
            this.successes.add(explanation);
        }
        this.validationResults.addResult(result);
        return explanation;
    }

    public void addSuccesses(List<AssertionExplanation> results) {
        this.successes.addAll(results);
    }

    public void addFailures(List<AssertionExplanation> results) {
        this.failures.addAll(results);
    }

    public void addErrorCode(MediaValidationCode code) {
        this.errorCodes.add(code);
    }

    public void addErrorCodes(List<MediaValidationCode> codes) {
        this.errorCodes.addAll(codes);
    }
}

