/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat.impl;

import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.impl.AssertionExplanation;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import com.apple.jingle.leghorn.fileformat.impl.Predicate;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.MediaFileBackedByXmlDescription;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Node;

public class ConformanceProfile {
    private static Logger logger = Logger.getLogger(ConformanceProfile.class);
    protected String name = "<unnamed conformance profile>";
    protected ContainerType containerType;
    protected Predicate childPredicate;
    protected Blacklist blacklist;

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public void setContainerType(ContainerType containerType) {
        this.containerType = containerType;
        this.childPredicate.resolveReferences(containerType);
    }

    public Predicate getChildPredicate() {
        return this.childPredicate;
    }

    public void addChildPredicate(Predicate pred) {
        if (this.childPredicate != null) {
            throw new IllegalArgumentException("Bad xml! Setting more than one top-level predicate in ConformanceProfile: " + this + " Predicate: " + pred);
        }
        this.childPredicate = pred;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final boolean testNode(Node node) {
        return this.testNode(node, null);
    }

    public boolean testNode(Node node, ConformanceResultGatherer gatherer) {
        boolean valid = this.childPredicate.evaluate(node, gatherer);
        if (gatherer != null) {
            this.findLineNumbers(node, gatherer.getFailures());
        }
        return valid;
    }

    public boolean testNode(@Nonnull MediaFile mediaFile, @Nullable ConformanceResultGatherer gatherer) {
        if (mediaFile instanceof MediaFileBackedByXmlDescription) {
            return this.testNode(((MediaFileBackedByXmlDescription)mediaFile).getXmlDescriptionNode(), gatherer);
        }
        return false;
    }

    private void findLineNumbers(Node node, List<AssertionExplanation> explanationList) {
        block9: {
            if (explanationList != null && !explanationList.isEmpty()) {
                XmlOptions opts = new XmlOptions();
                opts.setLoadLineNumbers();
                int aeIdx = 0;
                try {
                    String xmlstr = XMLUtil.nodeToString((Node)node);
                    XmlObject xmlObj = XmlObject.Factory.parse(xmlstr, opts);
                    for (AssertionExplanation ae : explanationList) {
                        List<String> xpaths = ae.getAssertion().getHighlights();
                        if (ae.getAssertion().getHighlights().isEmpty()) {
                            xpaths = ae.getAssertion().getArguments();
                        }
                        Vector<XmlLineNumber> lineNumbers = new Vector<XmlLineNumber>();
                        for (String xpath : xpaths) {
                            if (xpath.startsWith("/")) {
                                xpath = "." + xpath.trim();
                            }
                            XmlObject[] matches = xmlObj.selectPath(xpath, opts);
                            for (int i = 0; i < matches.length; ++i) {
                                XmlCursor xcur = matches[i].newCursor();
                                if (xcur.isAttr()) {
                                    xcur.toParent();
                                }
                                XmlLineNumber ln = (XmlLineNumber)xcur.getBookmark(XmlLineNumber.class);
                                logger.debug((Object)("name: " + xcur.getName()));
                                logger.debug((Object)("chars: " + xcur.getChars()));
                                if (ln == null) continue;
                                lineNumbers.add(ln);
                                logger.debug((Object)(ln.getLine() + " " + ln.getColumn() + " " + ln));
                            }
                        }
                        ae.setLineNumbers(lineNumbers);
                        ++aeIdx;
                    }
                }
                catch (Exception xmle) {
                    logger.error((Object)"Error in xml line number finding", (Throwable)xmle);
                    if (aeIdx >= explanationList.size()) break block9;
                    AssertionExplanation aexp = explanationList.get(aeIdx);
                    aexp.setFormattedExplanation(aexp.getFormattedExplanation() + " (Error in finding line number: " + xmle + ")");
                }
            }
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).toString();
    }

    public void setBlacklist(Blacklist blacklist) {
        this.blacklist = blacklist;
    }

    public Blacklist getBlacklist() {
        if (null == MediaValidationCode.valueOfIntegerCode(this.blacklist.getCode()) && null != this.childPredicate && !this.childPredicate.getChildPredicates().isEmpty()) {
            for (Predicate child : this.childPredicate.getChildPredicates()) {
                MediaValidationCode code = MediaValidationCode.valueOfConformanceProfile(child.getName());
                if (null != code) {
                    this.blacklist.setCode(code.getCodeNumber());
                    continue;
                }
                logger.debug((Object)("No MediaValidationCode for '" + child.getName() + "': " + this.blacklist.getExplanation()));
            }
        }
        return this.blacklist;
    }

    public static class Blacklist {
        private int code;
        private String explanation;
        private String type;

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getExplanation() {
            return this.explanation;
        }

        public void setExplanation(String explanation) {
            this.explanation = explanation;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

