/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat;

import com.apple.jingle.leghorn.fileformat.ConformanceVerifier;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ContainerTypeVerifier;
import com.apple.jingle.leghorn.fileformat.ContentBasedMimeTypeChecker;
import com.apple.jingle.leghorn.fileformat.TikaBasedMimeTypeChecker;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriberNotFoundException;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionParseException;
import com.apple.jingle.leghorn.fileformat.exceptions.VerifierNotFoundException;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceProfile;
import com.apple.jingle.leghorn.fileformat.impl.ConformanceResultGatherer;
import com.apple.jingle.leghorn.fileformat.impl.ContainerDescriber;
import com.apple.jingle.leghorn.fileformat.impl.ContainerTypeFactory;
import com.apple.jingle.leghorn.fileformat.impl.ContainerVerifier;
import com.apple.jingle.leghorn.fileformat.impl.FormatTypeFactory;
import com.apple.jingle.leghorn.fileformat.impl.VerifierBuilder;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Verifier
implements ContainerTypeVerifier,
ConformanceVerifier {
    private ContainerTypeFactory containerTypeFactory;
    private FormatTypeFactory formatTypeFactory;
    private String environment;

    public static Verifier getDefaultVerifier() throws VerifierBuilder.UnableToBuildVerifierException {
        return Verifier._defaultVerifier();
    }

    public static Verifier getVerifier(String name) throws VerifierBuilder.UnableToBuildVerifierException {
        return VerifierBuilder.buildVerifier(name);
    }

    @Override
    public boolean verifyContainerType(URI uri, ContainerType type, ValidationListener listener) throws VerifierNotFoundException, IOException {
        ContainerVerifier verifier = this.containerTypeFactory.getVerifierForType(type);
        if (verifier != null) {
            return verifier.verifyContainerType(uri, type, listener);
        }
        throw new VerifierNotFoundException(type);
    }

    public boolean verifyContainerType(File file, ContainerType type, ValidationListener listener) throws VerifierNotFoundException, IOException {
        return this.verifyContainerType(file.toURI(), type, listener);
    }

    public boolean verifyContainerType(File file, ContainerType type) throws VerifierNotFoundException, IOException {
        return this.verifyContainerType(file.toURI(), type, null);
    }

    @Override
    public boolean verifyConformance(URI uri, ContainerType type, String profileName, @Nullable ConformanceResultGatherer gatherer) throws IOException, DescriptionException, DescriberNotFoundException {
        Node descriptionDocument = this.descriptionFromURI(uri, type);
        return Verifier.verifyConformance(descriptionDocument, type, profileName, gatherer);
    }

    private Node descriptionFromURI(URI uri, ContainerType type) throws IOException, DescriptionException, DescriberNotFoundException {
        Object descriptionDocument = this.getContainerTypeFactory().getDescriberForType(type).describe(uri, type).getDescriptionDocument();
        Node node = descriptionDocument instanceof Node ? (Node)descriptionDocument : null;
        return node;
    }

    @Override
    public boolean verifyConformance(String description, ContainerType type, String profileName, @Nullable ConformanceResultGatherer gatherer) throws DescriptionException {
        return Verifier._verifyConformance(description, type, profileName, gatherer);
    }

    private static boolean _verifyConformance(String description, ContainerType type, String profileName, @Nullable ConformanceResultGatherer gatherer) throws DescriptionParseException {
        Document descriptionDocument = Verifier.parseXML(description);
        return Verifier.verifyConformance(descriptionDocument, type, profileName, gatherer);
    }

    public static boolean verifyConformance(Node descriptionDocument, ContainerType type, String profileName) {
        return Verifier.verifyConformance(descriptionDocument, type, profileName, null);
    }

    public static boolean verifyConformance(Node descriptionDocument, ContainerType type, String profileName, @Nullable ConformanceResultGatherer gatherer) {
        if (descriptionDocument != null) {
            ConformanceProfile conformanceProfile = type.getConformanceProfile(profileName);
            if (conformanceProfile == null) {
                throw new IllegalArgumentException(String.format("Unknown conformance profileName '%s' for type: %s", profileName, type.getUTITypeName()));
            }
            return conformanceProfile.testNode(descriptionDocument, gatherer);
        }
        return false;
    }

    public static boolean verifyConformance(MediaFile mediaFile, ContainerType type, String profileName, @Nullable ConformanceResultGatherer gatherer) {
        if (mediaFile != null) {
            ConformanceProfile conformanceProfile = type.getConformanceProfile(profileName);
            if (conformanceProfile == null) {
                throw new IllegalArgumentException(String.format("Unknown conformance profileName '%s' for type: %s", profileName, type.getUTITypeName()));
            }
            return conformanceProfile.testNode(mediaFile, gatherer);
        }
        return false;
    }

    private static Document parseXML(String description) throws DescriptionParseException {
        try {
            return XMLUtil.getDocumentBuilderDisabledXXE().newDocumentBuilder().parse(new InputSource(new StringReader(description)));
        }
        catch (Exception e) {
            throw new DescriptionParseException(e);
        }
    }

    public String getMimeTypeBasedOnContent(@Nonnull URI uri) {
        return new TikaBasedMimeTypeChecker().getMimeType(uri);
    }

    public ContentBasedMimeTypeChecker.MimeTypeMatchResult mimeTypeMatches(@Nonnull URI uri, @Nonnull ContainerType containerType) {
        return new TikaBasedMimeTypeChecker().mimeTypeMatches(uri, containerType);
    }

    public String getMimeTypeBasedOnContent(@Nonnull File file) {
        return new TikaBasedMimeTypeChecker().getMimeType(file);
    }

    public ContentBasedMimeTypeChecker.MimeTypeMatchResult mimeTypeMatches(@Nonnull File file, @Nonnull ContainerType containerType) {
        return new TikaBasedMimeTypeChecker().mimeTypeMatches(file, containerType);
    }

    public <T> ContainerDescription<T> describe(File file, ContainerType type) throws IOException, DescriptionException, DescriberNotFoundException {
        return this.describe(file.toURI(), type);
    }

    public <T> ContainerDescription<T> describe(URI uri, ContainerType type) throws DescriberNotFoundException, DescriptionException, IOException {
        ContainerDescriber<?> describer = this.getContainerTypeFactory().getDescriberForType(type);
        if (describer != null) {
            return describer.describe(uri, type);
        }
        throw new DescriberNotFoundException(type);
    }

    public <T> ContainerDescription<T> describe(Describable describable, ContainerType type) throws DescriberNotFoundException, DescriptionException, IOException {
        ContainerDescriber<?> describer = this.getContainerTypeFactory().getDescriberForType(type);
        if (describer != null) {
            return describer.describe(describable, type);
        }
        throw new DescriberNotFoundException(type);
    }

    public ContainerTypeFactory getContainerTypeFactory() {
        return this.containerTypeFactory;
    }

    public void setContainerTypeFactory(ContainerTypeFactory containerTypeFactory) {
        this.containerTypeFactory = containerTypeFactory;
    }

    public FormatTypeFactory getFormatTypeFactory() {
        return this.formatTypeFactory;
    }

    public void setFormatTypeFactory(FormatTypeFactory formatTypeFactory) {
        this.formatTypeFactory = formatTypeFactory;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    private static Verifier _defaultVerifier() throws VerifierBuilder.UnableToBuildVerifierException {
        return VerifierBuilder.buildDefault();
    }

    public static interface Describable {
        @Nonnull
        public String getName();

        @Nonnull
        public URI getUri();

        @Nonnull
        public File getLocalFile() throws IOException;

        @Nonnull
        public InputStream getInputStream() throws IOException;
    }
}

