/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat;

import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class ValidationInfo {
    protected long position = -1L;
    protected long line = -1L;
    protected long column = -1L;
    protected String userString = "";
    protected MediaValidationCode code;
    private static Logger log = Logger.getLogger(ValidationInfo.class);

    public static List<MediaValidationCode> convertValidationInfosToErrorCodes(List<ValidationInfo> infos, MediaValidationCode defaultCode) {
        return ValidationInfo.convertValidationInfosToErrorCodes(infos, defaultCode, false);
    }

    public static List<MediaValidationCode> convertValidationInfosToErrorCodes(List<ValidationInfo> infos, MediaValidationCode defaultCode, boolean warnIfDefault) {
        ArrayList<MediaValidationCode> codes = new ArrayList<MediaValidationCode>(infos.size());
        for (ValidationInfo info : infos) {
            if (info == null) continue;
            MediaValidationCode code = info.getCode();
            if (code == null) {
                code = defaultCode;
                if (warnIfDefault) {
                    log.warn((Object)("No ValidationInfo.ErrorCode: " + info));
                }
            }
            codes.add(code);
        }
        return codes;
    }

    public ValidationInfo(String userString, long position, long line, long column) {
        this(userString, position);
        this.line = line;
        this.column = column;
    }

    public ValidationInfo(String userString) {
        this.userString = userString;
    }

    public ValidationInfo(String message, long position) {
        this(message);
        this.position = position;
    }

    public ValidationInfo(String message, MediaValidationCode code) {
        this(message);
        this.code = code;
    }

    public String getUserString() {
        return this.userString;
    }

    public long getLineNumber() {
        return this.line;
    }

    public long getColumn() {
        return this.column;
    }

    public long getPosition() {
        return this.position;
    }

    public MediaValidationCode getCode() {
        return this.code;
    }

    public void setCode(MediaValidationCode code) {
        this.code = code;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this).append("userString", (Object)this.userString);
        if (this.position != -1L) {
            toStringBuilder.append("position", this.position);
        }
        if (this.line != -1L || this.column != -1L) {
            toStringBuilder.append("line", this.line).append("column", this.column);
        }
        return toStringBuilder.toString();
    }
}

