/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat;

import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ContentBasedMimeTypeChecker;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;

public class TikaBasedMimeTypeChecker
implements ContentBasedMimeTypeChecker {
    private static final Logger log = Logger.getLogger(TikaBasedMimeTypeChecker.class);

    @Override
    @Nullable
    public String getMimeType(@Nullable URI uri) {
        if (uri == null) {
            return null;
        }
        Metadata metadata = new Metadata();
        if (!Strings.isNullOrEmpty((String)uri.getPath())) {
            metadata.add("resourceName", uri.getPath());
        }
        MediaType detectedMimeType = null;
        try {
            detectedMimeType = TikaConfig.getDefaultConfig().getDetector().detect((InputStream)TikaInputStream.get((URI)uri), metadata);
        }
        catch (IOException e) {
            log.warn((Object)String.format("Error getting Tika input stream for %s: %s", uri.getPath(), e));
            return null;
        }
        return detectedMimeType.toString();
    }

    @Override
    @Nullable
    public String getMimeType(@Nullable File file) {
        if (file == null) {
            return null;
        }
        return this.getMimeType(file.toURI());
    }

    @Override
    @Nonnull
    public ContentBasedMimeTypeChecker.MimeTypeMatchResult mimeTypeMatches(@Nonnull URI uri, @Nonnull ContainerType specifiedContainerType) {
        String specifiedMimeType = specifiedContainerType.getMIMETypeName();
        if (Strings.isNullOrEmpty((String)specifiedMimeType)) {
            log.info((Object)String.format("No specified mime type for %s for Tika to compare to", uri.getPath()));
            return ContentBasedMimeTypeChecker.MimeTypeMatchResult.NO_SPECIFIED_MIME_TYPE;
        }
        MediaType specifiedMediaType = MediaType.parse((String)specifiedMimeType);
        if (specifiedMediaType == null) {
            log.info((Object)String.format("Failed to convert %s into a Tika MediaType", specifiedMimeType));
            return ContentBasedMimeTypeChecker.MimeTypeMatchResult.NO_SPECIFIED_MIME_TYPE;
        }
        String detectedMimeType = this.getMimeType(uri);
        if (Strings.isNullOrEmpty((String)detectedMimeType)) {
            log.info((Object)String.format("Failed to get Tika MediaType for %s", uri.getPath()));
            return ContentBasedMimeTypeChecker.MimeTypeMatchResult.FAILED_TO_GET_MIME_TYPE;
        }
        MediaType detectedMediaType = MediaType.parse((String)detectedMimeType);
        log.info((Object)String.format("Detected container type for %s: %s", uri.getPath(), detectedMediaType));
        return this.compareMediaTypes(specifiedMediaType, detectedMediaType);
    }

    @Override
    @Nonnull
    public ContentBasedMimeTypeChecker.MimeTypeMatchResult mimeTypeMatches(@Nonnull File file, @Nonnull ContainerType specifiedContainerType) {
        return this.mimeTypeMatches(file.toURI(), specifiedContainerType);
    }

    private ContentBasedMimeTypeChecker.MimeTypeMatchResult compareMediaTypes(@Nonnull MediaType specifiedMediaType, @Nonnull MediaType detectedMediaType) {
        MediaType normalizedAliasType;
        MediaType normalizedDetectedMediaType;
        MediaType normalizedSpecifiedMediaType;
        MediaTypeRegistry registry = TikaConfig.getDefaultConfig().getMediaTypeRegistry();
        if (this.compareNormalizedMediaType(registry, normalizedSpecifiedMediaType = registry.normalize(specifiedMediaType), normalizedDetectedMediaType = registry.normalize(detectedMediaType)) == ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_MATCH) {
            return ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_MATCH;
        }
        for (MediaType aliasType : registry.getAliases(detectedMediaType)) {
            normalizedAliasType = registry.normalize(aliasType);
            if (this.compareNormalizedMediaType(registry, normalizedSpecifiedMediaType, normalizedAliasType) != ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_MATCH) continue;
            log.debug((Object)String.format("Specified media type %s matched alias type of detected media type %s", specifiedMediaType, aliasType.toString()));
            return ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_MATCH;
        }
        for (MediaType aliasType : registry.getAliases(specifiedMediaType)) {
            normalizedAliasType = registry.normalize(aliasType);
            if (this.compareNormalizedMediaType(registry, normalizedAliasType, normalizedDetectedMediaType) != ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_MATCH) continue;
            log.debug((Object)String.format("Alias type of specified media type %s matched %s", specifiedMediaType, normalizedDetectedMediaType));
            return ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_MATCH;
        }
        if (registry.getSupertype(detectedMediaType) == null) {
            return ContentBasedMimeTypeChecker.MimeTypeMatchResult.FAILED_TO_GET_MIME_TYPE;
        }
        return ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_DO_NOT_MATCH;
    }

    private ContentBasedMimeTypeChecker.MimeTypeMatchResult compareNormalizedMediaType(@Nonnull MediaTypeRegistry registry, @Nonnull MediaType normedSpecifiedMediaType, @Nonnull MediaType normedDetectedMediaType) {
        if (registry.isInstanceOf(normedDetectedMediaType, normedSpecifiedMediaType)) {
            return ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_MATCH;
        }
        List<MediaType> customAliasesToCheckAgainst = this.getCustomAliases(normedSpecifiedMediaType);
        if (!customAliasesToCheckAgainst.isEmpty()) {
            for (MediaType mediaType : customAliasesToCheckAgainst) {
                if (!registry.isInstanceOf(normedDetectedMediaType, mediaType)) continue;
                log.debug((Object)String.format("Alias type %s matched %s", mediaType.toString(), normedDetectedMediaType));
                return ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_MATCH;
            }
        }
        return ContentBasedMimeTypeChecker.MimeTypeMatchResult.MIME_TYPES_DO_NOT_MATCH;
    }

    private List<MediaType> getCustomAliases(@Nonnull MediaType specifiedMediaType) {
        ArrayList<MediaType> aliases = new ArrayList<MediaType>();
        MediaType xSpecifiedType = MediaType.parse((String)(specifiedMediaType.getType() + "/x-" + specifiedMediaType.getSubtype()));
        aliases.add(xSpecifiedType);
        if ("video/mp2p".equalsIgnoreCase(specifiedMediaType.toString())) {
            aliases.add(MediaType.parse((String)"video/mpeg"));
        } else if ("application/epub".equalsIgnoreCase(specifiedMediaType.toString())) {
            aliases.add(MediaType.APPLICATION_ZIP);
        } else if ("application/iosAppArchive".equalsIgnoreCase(specifiedMediaType.toString())) {
            aliases.add(MediaType.APPLICATION_ZIP);
        } else if ("audio/m4a".equalsIgnoreCase(specifiedMediaType.toString())) {
            aliases.add(MediaType.parse((String)"audio/mp4"));
        } else if ("video/m4v".equalsIgnoreCase(specifiedMediaType.toString())) {
            aliases.add(MediaType.parse((String)"video/mp4"));
            aliases.add(MediaType.parse((String)"video/quicktime"));
        } else if ("application/x-scc".equalsIgnoreCase(specifiedMediaType.toString())) {
            aliases.add(MediaType.parse((String)"text/plain"));
        } else if ("application/x-ttaf1-dfxp".equalsIgnoreCase(specifiedMediaType.toString())) {
            aliases.add(MediaType.parse((String)"application/xml"));
        } else if ("audio/aac".equalsIgnoreCase(specifiedMediaType.toString())) {
            aliases.add(MediaType.parse((String)"audio/mpeg"));
        }
        return aliases;
    }
}

